/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.IntSet;
import com.sun.glass.ui.monocle.TouchFilter;
import com.sun.glass.ui.monocle.TouchInput;
import com.sun.glass.ui.monocle.TouchState;
import java.util.Arrays;

final class AssignPointIDTouchFilter
implements TouchFilter {
    private final TouchState oldState = new TouchState();
    private int[] mappedIndices = new int[1];
    private IntSet ids = new IntSet();
    private int nextID = 1;

    AssignPointIDTouchFilter() {
        TouchInput.getInstance().getState(this.oldState);
    }

    private int acquireID() {
        this.ids.addInt(this.nextID);
        return this.nextID++;
    }

    private void releaseID(int id) {
        this.ids.removeInt(id);
        this.nextID = 1;
        for (int i = 0; i < this.ids.size(); ++i) {
            this.nextID = Math.max(this.ids.get(i) + 1, this.nextID);
        }
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public boolean filter(TouchState state) {
        int i;
        if (this.oldState.getPointCount() == 0) {
            for (i = 0; i < state.getPointCount(); ++i) {
                state.getPoint((int)i).id = this.acquireID();
            }
        } else if (state.getPointCount() >= this.oldState.getPointCount()) {
            if (this.mappedIndices.length < state.getPointCount()) {
                this.mappedIndices = new int[state.getPointCount()];
            } else {
                Arrays.fill(this.mappedIndices, 0);
            }
            mappedIndexCount = 0;
            for (i = 0; i < this.oldState.getPointCount(); ++i) {
                TouchState.Point oldPoint = this.oldState.getPoint(i);
                x = oldPoint.x;
                y = oldPoint.y;
                int closestDistanceSquared = Integer.MAX_VALUE;
                int mappedIndex = -1;
                for (int j = 0; j < state.getPointCount(); ++j) {
                    if (this.mappedIndices[j] != 0) continue;
                    TouchState.Point newPoint = state.getPoint(j);
                    distanceX = x - newPoint.x;
                    distanceY = y - newPoint.y;
                    distanceSquared = distanceX * distanceX + distanceY * distanceY;
                    if (distanceSquared >= closestDistanceSquared) continue;
                    mappedIndex = j;
                    closestDistanceSquared = distanceSquared;
                }
                assert (mappedIndex >= 0);
                state.getPoint((int)mappedIndex).id = oldPoint.id;
                ++mappedIndexCount;
                this.mappedIndices[mappedIndex] = 1;
            }
            if (mappedIndexCount < state.getPointCount()) {
                for (i = 0; i < state.getPointCount(); ++i) {
                    if (this.mappedIndices[i] != 0) continue;
                    state.getPoint((int)i).id = this.acquireID();
                }
            }
        } else {
            if (this.mappedIndices.length < this.oldState.getPointCount()) {
                this.mappedIndices = new int[this.oldState.getPointCount()];
            } else {
                Arrays.fill(this.mappedIndices, 0);
            }
            mappedIndexCount = 0;
            for (i = 0; i < state.getPointCount() && mappedIndexCount < this.oldState.getPointCount(); ++mappedIndexCount, ++i) {
                TouchState.Point newPoint = state.getPoint(i);
                x = newPoint.x;
                y = newPoint.y;
                int closestDistanceSquared = Integer.MAX_VALUE;
                int mappedIndex = -1;
                for (int j = 0; j < this.oldState.getPointCount(); ++j) {
                    if (this.mappedIndices[j] != 0) continue;
                    TouchState.Point oldPoint = this.oldState.getPoint(j);
                    distanceX = x - oldPoint.x;
                    distanceY = y - oldPoint.y;
                    distanceSquared = distanceX * distanceX + distanceY * distanceY;
                    if (distanceSquared >= closestDistanceSquared) continue;
                    mappedIndex = j;
                    closestDistanceSquared = distanceSquared;
                }
                assert (mappedIndex >= 0);
                state.getPoint((int)i).id = this.oldState.getPoint((int)mappedIndex).id;
                this.mappedIndices[mappedIndex] = 1;
            }
        }
        for (i = 0; i < this.oldState.getPointCount(); ++i) {
            int id = this.oldState.getPoint((int)i).id;
            TouchState.Point p = state.getPointForID(id);
            if (p != null) continue;
            this.releaseID(id);
        }
        state.copyTo(this.oldState);
        return false;
    }

    @Override
    public boolean flush(TouchState state) {
        return false;
    }

    public boolean equals(Object o) {
        return o instanceof AssignPointIDTouchFilter;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "AssignPointID";
    }
}

