/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Timer;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

final class MonocleTimer
extends Timer {
    private static final String THREAD_NAME = "Monocle Timer";
    private static ScheduledThreadPoolExecutor scheduler;
    private ScheduledFuture<?> task;

    MonocleTimer(Runnable runnable) {
        super(runnable);
    }

    static int getMinPeriod_impl() {
        return 0;
    }

    static int getMaxPeriod_impl() {
        return 1000000;
    }

    protected long _start(Runnable runnable, int period) {
        if (scheduler == null) {
            scheduler = new ScheduledThreadPoolExecutor(1, target -> {
                Thread thread = new Thread(target, THREAD_NAME);
                thread.setDaemon(true);
                return thread;
            });
        }
        this.task = scheduler.scheduleAtFixedRate(runnable, 0L, period, TimeUnit.MILLISECONDS);
        return 1L;
    }

    protected long _start(Runnable runnable) {
        throw new RuntimeException("vsync timer not supported");
    }

    protected void _stop(long timer) {
        if (this.task != null) {
            this.task.cancel(false);
            this.task = null;
        }
    }

    protected void _pause(long timer) {
    }

    protected void _resume(long timer) {
    }
}

