/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.framework.junit;

import java.util.function.Consumer;
import javafx.application.Application;
import javafx.stage.Stage;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.testfx.api.FxRobot;
import org.testfx.api.FxToolkit;
import org.testfx.framework.junit.ApplicationAdapter;
import org.testfx.framework.junit.ApplicationFixture;

public class ApplicationRule
extends FxRobot
implements ApplicationFixture,
TestRule {
    private final Consumer<Stage> start;
    private final Consumer<Stage> stop;
    private Stage stage;

    public ApplicationRule(Consumer<Stage> start) {
        this(start, doNothing -> {});
    }

    public ApplicationRule(Consumer<Stage> start, Consumer<Stage> stop) {
        this.start = start;
        this.stop = stop;
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public void start(Stage stage) throws Exception {
        stage.centerOnScreen();
        this.start.accept(stage);
        this.stage = stage;
    }

    @Override
    public void stop() throws Exception {
        this.stop.accept(this.stage);
    }

    private void before() throws Exception {
        FxToolkit.registerPrimaryStage();
        FxToolkit.setupApplication(() -> new ApplicationAdapter(this));
    }

    private void after() throws Exception {
        FxToolkit.cleanupAfterTest((FxRobot)this, (Application)new ApplicationAdapter(this));
    }

    private Statement externalResource(final Statement base) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ApplicationRule.this.before();
                try {
                    base.evaluate();
                }
                finally {
                    ApplicationRule.this.after();
                }
            }
        };
    }

    public Statement apply(Statement base, Description description) {
        return this.externalResource(base);
    }
}

