/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.persist.PersistService;
import com.google.inject.persist.jpa.JpaPersistModule;
import examples.database.PostgresDataSourceProvider;
import examples.service.GreetingsService;
import io.grpc.BindableService;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyComponentPathImpl;
import org.hibernate.boot.model.naming.PhysicalNamingStrategyStandardImpl;

public class GreetingsModule
extends AbstractModule {
    private Map<String, Object> jpaProperties;

    protected void configure() {
        this.jpaProperties = new HashMap<String, Object>();
        JpaPersistModule jpaPersistModule = new JpaPersistModule("example.greetings");
        jpaPersistModule.properties(this.jpaProperties);
        this.install((Module)jpaPersistModule);
        this.bind(DataSource.class).toProvider(PostgresDataSourceProvider.class).in(Singleton.class);
        Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), BindableService.class);
        multibinder.addBinding().to(GreetingsService.class);
        this.requestInjection((Object)this);
    }

    @Inject
    void startPersistService(PersistService persistService, DataSource dataSource) {
        this.jpaProperties.put("hibernate.connection.datasource", dataSource);
        this.jpaProperties.put("hibernate.physical_naming_strategy", new PhysicalNamingStrategyStandardImpl());
        this.jpaProperties.put("hibernate.implicit_naming_strategy", new ImplicitNamingStrategyComponentPathImpl());
        persistService.start();
    }
}

