/*
 * Decompiled with CFR 0.152.
 */
package examples.service;

import com.google.inject.persist.Transactional;
import com.google.protobuf.Empty;
import example.grpc.GreetingsGrpc;
import example.grpc.common.GreetingId;
import example.grpc.common.GreetingRequest;
import example.grpc.common.GreetingResponse;
import examples.service.entity.GreetingEntity;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.persistence.EntityManager;

@Transactional
public class GreetingsService
extends GreetingsGrpc.GreetingsImplBase {
    private final EntityManager entityManager;

    @Inject
    GreetingsService(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(GreetingRequest greetingRequest, StreamObserver<GreetingId> streamObserver) {
        try {
            GreetingEntity greetingEntity = new GreetingEntity(greetingRequest.getPhrase());
            this.entityManager.persist((Object)greetingEntity);
            GreetingId greetingId = GreetingId.newBuilder().setId(greetingEntity.getId().toString()).build();
            streamObserver.onNext((Object)greetingId);
        }
        catch (Exception exception) {
            streamObserver.onError((Throwable)exception);
        }
        finally {
            streamObserver.onCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(GreetingId greetingId, StreamObserver<GreetingResponse> streamObserver) {
        try {
            UUID uUID = UUID.fromString(greetingId.getId());
            GreetingEntity greetingEntity = (GreetingEntity)this.entityManager.getReference(GreetingEntity.class, (Object)uUID);
            GreetingResponse greetingResponse = GreetingResponse.newBuilder().setId(greetingEntity.getId().toString()).setPhrase(greetingEntity.getPhrase()).build();
            streamObserver.onNext((Object)greetingResponse);
        }
        catch (Exception exception) {
            streamObserver.onError((Throwable)exception);
        }
        finally {
            streamObserver.onCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void list(Empty empty, StreamObserver<GreetingResponse> streamObserver) {
        try {
            List list = this.entityManager.createQuery("SELECT g FROM GreetingEntity g").getResultList();
            list.stream().map(greetingEntity -> GreetingResponse.newBuilder().setId(greetingEntity.getId().toString()).setPhrase(greetingEntity.getPhrase()).build()).forEach(greetingResponse -> streamObserver.onNext(greetingResponse));
        }
        catch (Exception exception) {
            streamObserver.onError((Throwable)exception);
        }
        finally {
            streamObserver.onCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(GreetingId greetingId, StreamObserver<Empty> streamObserver) {
        try {
            UUID uUID = UUID.fromString(greetingId.getId());
            GreetingEntity greetingEntity = (GreetingEntity)this.entityManager.getReference(GreetingEntity.class, (Object)uUID);
            this.entityManager.remove((Object)greetingEntity);
        }
        catch (Exception exception) {
            streamObserver.onError((Throwable)exception);
        }
        finally {
            streamObserver.onNext((Object)Empty.getDefaultInstance());
            streamObserver.onCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(GreetingRequest greetingRequest, StreamObserver<Empty> streamObserver) {
        try {
            UUID uUID = UUID.fromString(greetingRequest.getId());
            GreetingEntity greetingEntity = (GreetingEntity)this.entityManager.getReference(GreetingEntity.class, (Object)uUID);
            greetingEntity.setPhrase(greetingRequest.getPhrase());
            this.entityManager.persist((Object)greetingEntity);
        }
        catch (Exception exception) {
            streamObserver.onError((Throwable)exception);
        }
        finally {
            streamObserver.onNext((Object)Empty.getDefaultInstance());
            streamObserver.onCompleted();
        }
    }
}

