/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.virtualresource.docker;

import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.AnsiProgressHandler;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.auth.RegistryAuthSupplier;
import com.spotify.docker.client.exceptions.DockerCertificateException;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.PortBinding;
import com.spotify.docker.client.messages.RegistryAuth;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.SyncFailsafe;
import org.testifyproject.TestContext;
import org.testifyproject.VirtualResourceInstance;
import org.testifyproject.VirtualResourceProvider;
import org.testifyproject.annotation.VirtualResource;
import org.testifyproject.core.VirtualResourceInstanceBuilder;
import org.testifyproject.core.util.ExceptionUtil;
import org.testifyproject.core.util.ExpressionUtil;
import org.testifyproject.core.util.LoggingUtil;
import org.testifyproject.guava.common.net.InetAddresses;
import org.testifyproject.trait.PropertiesReader;
import org.testifyproject.virtualresource.docker.DockerHubRegistryAuthSupplier;

public class DockerVirtualResourceProvider
implements VirtualResourceProvider<DefaultDockerClient.Builder> {
    public static final String DEFAULT_CONFIG_KEY = "docker";
    public static final String DEFAULT_VERSION = "latest";
    private DefaultDockerClient client;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public DefaultDockerClient.Builder configure(TestContext testContext, VirtualResource virtualResource, PropertiesReader configReader) {
        try {
            DefaultDockerClient.Builder builder = DefaultDockerClient.fromEnv();
            PropertiesReader reader = configReader;
            if (reader.isEmpty().booleanValue()) {
                reader = testContext.getPropertiesReader(DEFAULT_CONFIG_KEY);
            }
            if (!reader.isEmpty().booleanValue()) {
                RegistryAuth registryAuth = RegistryAuth.builder().serverAddress((String)reader.getProperty("uri")).email((String)reader.getProperty("email")).username((String)reader.getProperty("username")).password((String)reader.getProperty("password")).build();
                DockerHubRegistryAuthSupplier dockerHubAuthSupplier = new DockerHubRegistryAuthSupplier(registryAuth);
                builder.registryAuthSupplier((RegistryAuthSupplier)dockerHubAuthSupplier).connectTimeoutMillis(10000L).connectionPoolSize(16);
            }
            return builder;
        }
        catch (DockerCertificateException e) {
            throw ExceptionUtil.INSTANCE.propagate((Throwable)e);
        }
    }

    public VirtualResourceInstance start(TestContext testContext, VirtualResource virtualResource, DefaultDockerClient.Builder clientBuilder) {
        if (this.started.compareAndSet(false, true)) {
            VirtualResourceInstance virtualResourceInstance = null;
            int nodes = virtualResource.nodes();
            try {
                for (int i = 1; i <= nodes; ++i) {
                    LoggingUtil.INSTANCE.info("Connecting to {}", new Object[]{clientBuilder.uri()});
                    this.client = clientBuilder.build();
                    String imageName = virtualResource.value();
                    String imageTag = this.getImageTag(virtualResource.version());
                    String image = imageName + ":" + imageTag;
                    boolean imagePulled = this.isImagePulled(image, imageTag);
                    if (virtualResource.pull() && !imagePulled) {
                        this.pullImage(virtualResource, image);
                    }
                    ContainerConfig.Builder containerConfigBuilder = ContainerConfig.builder().image(image);
                    if (!virtualResource.cmd().isEmpty()) {
                        containerConfigBuilder.cmd(new String[]{virtualResource.cmd()});
                    }
                    String containerName = nodes == 1 ? (virtualResource.name().isEmpty() ? String.format("%s-%s", testContext.getName(), UUID.randomUUID().toString()) : String.format("%s-%s", virtualResource.name(), UUID.randomUUID().toString())) : (virtualResource.name().isEmpty() ? String.format("%s-%d-%s", testContext.getName(), i, UUID.randomUUID().toString()) : String.format("%s-%d-%s", virtualResource.name(), i, UUID.randomUUID().toString()));
                    HostConfig.Builder hostConfigBuilder = HostConfig.builder();
                    if (virtualResource.link()) {
                        List list = testContext.findCollection("dockerContainers").stream().map(p -> p.name().replace("/", "")).collect(Collectors.toList());
                        hostConfigBuilder.links(list);
                    }
                    for (String env : virtualResource.env()) {
                        try {
                            Map<String, Object> templateContext = testContext.findCollection("dockerContainers").stream().collect(Collectors.toMap(p -> p.name().replace("/", ""), p -> p));
                            String evaluation = ExpressionUtil.INSTANCE.evaluateTemplate(env, templateContext);
                            containerConfigBuilder.env(new String[]{evaluation});
                        }
                        catch (Exception e) {
                            LoggingUtil.INSTANCE.debug("Could not evaluate env '{}' as an expression ", new Object[]{env});
                        }
                    }
                    HostConfig hostConfig = hostConfigBuilder.publishAllPorts(Boolean.valueOf(true)).build();
                    ContainerConfig containerConfig = containerConfigBuilder.hostConfig(hostConfig).build();
                    ContainerCreation containerCreation = this.client.createContainer(containerConfig, containerName);
                    String containerId = containerCreation.id();
                    this.client.startContainer(containerId);
                    ContainerInfo containerInfo = this.client.inspectContainer(containerId);
                    InetAddress containerAddress = InetAddresses.forString((String)containerInfo.networkSettings().ipAddress());
                    ImmutableMap containerPorts = containerInfo.networkSettings().ports();
                    testContext.addCollectionElement("dockerContainers", (Object)containerInfo);
                    if (containerPorts != null) {
                        Map mappedPorts = containerPorts.entrySet().stream().collect(Collectors.collectingAndThen(Collectors.toMap(k -> Integer.valueOf(((String)k.getKey()).split("/")[0]), v -> Integer.valueOf(((PortBinding)((List)v.getValue()).get(0)).hostPort())), Collections::unmodifiableMap));
                        if (virtualResource.await()) {
                            this.waitForPorts(virtualResource, mappedPorts, containerAddress);
                        }
                    }
                    if (i != 1) continue;
                    virtualResourceInstance = VirtualResourceInstanceBuilder.builder().resource((Object)containerAddress, InetAddress.class).property("dockerClient", (Object)this.client).property("dockerContainer", (Object)containerInfo).build(image, virtualResource);
                }
                return virtualResourceInstance;
            }
            catch (Exception e) {
                this.stop(testContext, virtualResource, virtualResourceInstance);
                throw ExceptionUtil.INSTANCE.propagate((Throwable)e);
            }
        }
        throw ExceptionUtil.INSTANCE.propagate("Docker containers already started.", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(TestContext testContext, VirtualResource virtualResource, VirtualResourceInstance instance) {
        try {
            if (this.started.compareAndSet(true, false)) {
                testContext.findCollection("dockerContainers").stream().map(p -> p.id()).forEachOrdered(containerId -> {
                    LoggingUtil.INSTANCE.info("Stopping and Removing Docker Container {}", new Object[]{containerId});
                    RetryPolicy retryPolicy = new RetryPolicy().retryOn(Throwable.class).withBackoff(virtualResource.delay(), virtualResource.maxDelay(), virtualResource.unit());
                    this.stopContainer((String)containerId, retryPolicy);
                });
            }
        }
        finally {
            if (this.client != null) {
                this.client.close();
            }
        }
    }

    String getImageTag(String version) {
        String imageTag = version.isEmpty() ? DEFAULT_VERSION : version;
        return imageTag;
    }

    boolean isImagePulled(String image, String imageTag) {
        boolean imagePulled = false;
        try {
            this.client.inspectImage(image);
            if (!DEFAULT_VERSION.equals(imageTag)) {
                imagePulled = true;
            }
        }
        catch (DockerException | InterruptedException e) {
            LoggingUtil.INSTANCE.info("Image '{}' not found", new Object[]{image});
        }
        return imagePulled;
    }

    void pullImage(VirtualResource virtualResource, String image) {
        RetryPolicy retryPolicy = new RetryPolicy().retryOn(Throwable.class).withDelay(virtualResource.delay(), virtualResource.unit()).withMaxRetries(virtualResource.maxRetries());
        ((SyncFailsafe)((SyncFailsafe)Failsafe.with((RetryPolicy)retryPolicy).onRetry(throwable -> LoggingUtil.INSTANCE.warn("Retrying pull request of image '{}'", new Object[]{image, throwable}))).onFailure(throwable -> LoggingUtil.INSTANCE.error("Image image '{}' could not be pulled: ", new Object[]{image, throwable}))).run(() -> this.client.pull(image, (ProgressHandler)new AnsiProgressHandler()));
    }

    void waitForPorts(VirtualResource virtualResource, Map<Integer, Integer> mappedPorts, InetAddress host) {
        RetryPolicy retryPolicy = new RetryPolicy().retryOn(IOException.class).withBackoff(virtualResource.delay(), virtualResource.maxDelay(), virtualResource.unit());
        int[] ports = virtualResource.ports();
        if (ports.length != 0) {
            for (int port : ports) {
                Failsafe.with((RetryPolicy)retryPolicy).run(() -> {
                    LoggingUtil.INSTANCE.info("Waiting for '{}:{}' to be reachable", new Object[]{host.getHostAddress(), port});
                    new Socket(host, port).close();
                });
            }
        } else {
            mappedPorts.entrySet().forEach(entry -> Failsafe.with((RetryPolicy)retryPolicy).run(() -> {
                LoggingUtil.INSTANCE.info("Waiting for '{}:{}' to be reachable", new Object[]{host.getHostAddress(), entry.getKey()});
                new Socket(host, (int)((Integer)entry.getKey())).close();
            }));
        }
    }

    void stopContainer(String containerId, RetryPolicy retryPolicy) {
        ((SyncFailsafe)((SyncFailsafe)((SyncFailsafe)Failsafe.with((RetryPolicy)retryPolicy).onRetry(throwable -> LoggingUtil.INSTANCE.info("Trying to stop Docker Container '{}'", new Object[]{containerId}))).onSuccess(result -> {
            LoggingUtil.INSTANCE.info("Docker Container '{}' stopped", new Object[]{containerId});
            this.removeContainer(containerId, retryPolicy);
        })).onFailure(throwable -> LoggingUtil.INSTANCE.error("Docker Container '{}' could not be stopped", new Object[]{containerId, throwable}))).run(() -> this.client.stopContainer(containerId, 8));
    }

    void removeContainer(String containerId, RetryPolicy retryPolicy) {
        ((SyncFailsafe)((SyncFailsafe)((SyncFailsafe)Failsafe.with((RetryPolicy)retryPolicy).onRetry(throwable -> LoggingUtil.INSTANCE.info("Trying to remove Docker Container '{}'", new Object[]{containerId}))).onSuccess(result -> LoggingUtil.INSTANCE.info("Docker Container '{}' removed", new Object[]{containerId}))).onFailure(throwable -> LoggingUtil.INSTANCE.error("Docker Container '{}' could not be removed", new Object[]{containerId, throwable}))).run(() -> this.client.removeContainer(containerId));
    }
}

