/*
 * Decompiled with CFR 0.152.
 */
package org.testinfected.hamcrest.dom;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.w3c.dom.Element;

public class HasAttribute
extends TypeSafeDiagnosingMatcher<Element> {
    private final String attributeName;

    public HasAttribute(String attributeName) {
        this.attributeName = attributeName;
    }

    protected boolean matchesSafely(Element actual, Description mismatchDescription) {
        boolean match = actual.hasAttribute(this.attributeName);
        if (!match) {
            mismatchDescription.appendText("no attribute ").appendValue((Object)this.attributeName);
        }
        return match;
    }

    public void describeTo(Description description) {
        description.appendText("has attribute ").appendValue((Object)this.attributeName);
    }

    @Factory
    public static Matcher<Element> isSelected() {
        return HasAttribute.hasAttribute("selected");
    }

    @Factory
    public static Matcher<Element> isReadOnly() {
        return HasAttribute.hasAttribute("readonly");
    }

    @Factory
    public static Matcher<Element> isChecked() {
        return HasAttribute.hasAttribute("checked");
    }

    @Factory
    public static Matcher<Element> isDisabled() {
        return HasAttribute.hasAttribute("disabled");
    }

    @Factory
    public static Matcher<Element> hasAttribute(String name) {
        return new HasAttribute(name);
    }
}

