/*
 * Decompiled with CFR 0.152.
 */
package org.testinfected.hamcrest.dom;

import org.hamcrest.Factory;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.AnyOf;
import org.w3c.dom.Element;

public class HasAttributeValue
extends FeatureMatcher<Element, String> {
    private final String attributeName;

    public HasAttributeValue(String attributeName, Matcher<? super String> valueMatcher) {
        super(valueMatcher, "has attribute \"" + attributeName + "\" with value", "\"" + attributeName + "\" value");
        this.attributeName = attributeName;
    }

    protected String featureValueOf(Element actual) {
        return actual.getAttribute(this.attributeName);
    }

    @Factory
    public static Matcher<Element> hasAttribute(String name, String value) {
        return HasAttributeValue.hasAttribute(name, (Matcher<? super String>)Matchers.equalTo((Object)value));
    }

    @Factory
    public static Matcher<Element> hasId(String id) {
        return HasAttributeValue.hasAttribute("id", (Matcher<? super String>)Matchers.equalTo((Object)id));
    }

    @Factory
    public static Matcher<Element> hasName(String name) {
        return HasAttributeValue.hasAttribute("name", (Matcher<? super String>)Matchers.equalTo((Object)name));
    }

    @Factory
    public static Matcher<Element> hasClassName(String className) {
        return HasAttributeValue.hasAttribute("class", (Matcher<? super String>)AnyOf.anyOf((Matcher)Matchers.equalTo((Object)className), (Matcher)Matchers.startsWith((String)(className + " ")), (Matcher)Matchers.endsWith((String)(" " + className)), (Matcher)Matchers.containsString((String)(" " + className + " "))));
    }

    @Factory
    public static Matcher<Element> hasAttribute(String name, Matcher<? super String> valueMatcher) {
        return new HasAttributeValue(name, valueMatcher);
    }
}

