/*
 * Decompiled with CFR 0.152.
 */
package org.testinfected.hamcrest.jpa;

import java.lang.reflect.Field;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.testinfected.hamcrest.jpa.Reflection;

public class HasFieldWithValue<T, U>
extends TypeSafeDiagnosingMatcher<T> {
    private final String fieldName;
    private final Matcher<? super U> valueMatcher;

    public HasFieldWithValue(String fieldName, Matcher<? super U> valueMatcher) {
        this.fieldName = fieldName;
        this.valueMatcher = valueMatcher;
    }

    protected boolean matchesSafely(T argument, Description mismatchDescription) {
        Field field = this.getField(argument, mismatchDescription);
        if (field == null) {
            return false;
        }
        Object fieldValue = Reflection.readField(argument, field);
        boolean valueMatches = this.valueMatcher.matches(fieldValue);
        if (!valueMatches) {
            mismatchDescription.appendText("\"" + this.fieldName + "\" ");
            this.valueMatcher.describeMismatch(fieldValue, mismatchDescription);
        }
        return valueMatches;
    }

    private Field getField(T argument, Description mismatchDescription) {
        try {
            return argument.getClass().getDeclaredField(this.fieldName);
        }
        catch (NoSuchFieldException e) {
            mismatchDescription.appendText("no field \"" + this.fieldName + "\"");
            return null;
        }
    }

    public void describeTo(Description description) {
        description.appendText("has field \"");
        description.appendText(this.fieldName);
        description.appendText("\": ");
        description.appendDescriptionOf(this.valueMatcher);
    }

    @Factory
    public static <T, U> Matcher<T> hasField(String field, Matcher<? super U> value) {
        return new HasFieldWithValue<T, U>(field, value);
    }

    @Factory
    public static <T> Matcher<T> hasField(String field) {
        return new HasFieldWithValue(field, Matchers.anything());
    }
}

