/*
 * Decompiled with CFR 0.152.
 */
package org.testinfected.hamcrest.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.validation.Path;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsIterableContainingInOrder;

public class HasNodesAlongPath
extends TypeSafeMatcher<Path> {
    private List<Matcher<? super Path.Node>> nodeMatchers;

    public HasNodesAlongPath(Matcher<? super Path.Node> ... nodeMatchers) {
        this(Arrays.asList(nodeMatchers));
    }

    public HasNodesAlongPath(List<Matcher<? super Path.Node>> nodeMatchers) {
        this.nodeMatchers = nodeMatchers;
    }

    protected boolean matchesSafely(Path path) {
        return IsIterableContainingInOrder.contains(this.nodeMatchers).matches((Object)path);
    }

    public void describeTo(Description description) {
        description.appendList("", "->", "", this.nodeMatchers);
    }

    public static HasNodesAlongPath path(String expression) {
        ArrayList<Matcher<? super Path.Node>> nodeMatchers = new ArrayList<Matcher<? super Path.Node>>();
        for (String component : expression.split("\\.")) {
            nodeMatchers.add(HasNodesAlongPath.nodeWithName(component));
        }
        return new HasNodesAlongPath(nodeMatchers);
    }

    public static Matcher<? super Path.Node> nodeWithName(String name) {
        return HasNodesAlongPath.nodeWithName((Matcher<? super String>)Matchers.equalTo((Object)("".equals(name) ? null : name)));
    }

    public static Matcher<? super Path.Node> nodeWithName(Matcher<? super String> nameMatcher) {
        return new FeatureMatcher<Path.Node, String>(nameMatcher, "", ""){

            protected String featureValueOf(Path.Node actual) {
                return actual.getName();
            }
        };
    }
}

