/*
 * Decompiled with CFR 0.152.
 */
package com.example.demo.springboot.app.data;

import com.example.demo.springboot.app.data.Customer;
import com.example.demo.springboot.app.data.CustomerRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CustomerController {
    private final CustomerRepository customerRepository;

    public CustomerController(CustomerRepository customerRepository) {
        this.customerRepository = customerRepository;
    }

    @RequestMapping(value={"/customers/{id}"})
    public ResponseEntity<Customer> findCustomer(@PathVariable long id) {
        Optional customer = this.customerRepository.findById(id);
        return customer.map(value -> ResponseEntity.status((HttpStatus)HttpStatus.OK).body(value)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping(value={"/customers"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<Customer> createCustomer(@RequestBody Customer customer) {
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body(this.customerRepository.save(customer));
    }

    @PutMapping(value={"/customers/{id}"})
    public ResponseEntity<Customer> updateCustomer(@RequestBody Customer customer, @PathVariable long id) {
        Optional existing = this.customerRepository.findById(id);
        if (!existing.isPresent()) {
            return ResponseEntity.notFound().build();
        }
        customer.setId(id);
        this.customerRepository.save(customer);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)customer);
    }

    @PatchMapping(value={"/customers/{id}"})
    public ResponseEntity<Customer> patchCustomer(@RequestBody Customer customer, @PathVariable long id) {
        Optional existing = this.customerRepository.findById(id);
        if (!existing.isPresent()) {
            return ResponseEntity.notFound().build();
        }
        if (null != customer.getFirstName()) {
            ((Customer)existing.get()).setFirstName(customer.getFirstName());
        }
        if (null != customer.getLastName()) {
            ((Customer)existing.get()).setLastName(customer.getLastName());
        }
        this.customerRepository.save(customer);
        return ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).build();
    }

    @DeleteMapping(value={"/customers/{id}"})
    public ResponseEntity<Object> deleteCustomer(@PathVariable long id) {
        this.customerRepository.deleteById(id);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/customers"})
    public List<Customer> getAllCustomers(@RequestParam(value="sortBy", required=false) String sortBy) {
        if (sortBy != null) {
            return this.customerRepository.findAll(Sort.by((String[])new String[]{sortBy}));
        }
        return this.customerRepository.findAll();
    }

    @GetMapping(value={"/customers/search/first-name"})
    public List<Customer> searchByFirstName(@RequestParam(value="name") String name) {
        return this.customerRepository.findByFirstName(name);
    }

    @GetMapping(value={"/customers/search/last-name"})
    public List<Customer> searchByLastName(@RequestParam(value="name") String name) {
        return this.customerRepository.findByLastName(name);
    }
}

