/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.charts;

import java.nio.file.Path;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.charts.ChartPluginResult;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;

public abstract class ChartIncludeBasePlugin
implements IncludePlugin {
    protected static String HORIZONTAL_KEY = "horizontal";
    protected static String HEIGHT_KEY = "height";
    protected static String STACK_KEY = "stack";
    protected static String WIDE_KEY = "wide";
    protected static String LEGEND_KEY = "legend";
    protected static String TIME_KEY = "time";
    protected static String BREAKPOINT_KEY = "breakpoint";
    protected static String COLUMNS = "columns";
    private Path fullPath;

    protected abstract String type();

    public PluginParamsDefinition parameters() {
        return new PluginParamsDefinition().add(HEIGHT_KEY, PluginParamType.NUMBER, "chart height", "500").add(HORIZONTAL_KEY, PluginParamType.BOOLEAN, "horizontal bars", "true").add(STACK_KEY, PluginParamType.BOOLEAN, "stack charts", "true").add(WIDE_KEY, PluginParamType.BOOLEAN, "use all horizontal space", "true").add(LEGEND_KEY, PluginParamType.BOOLEAN, "show legend", "true").add(TIME_KEY, PluginParamType.BOOLEAN, "treat X axis data as time series", "true").add(BREAKPOINT_KEY, PluginParamType.LIST_OR_SINGLE_STRING_OR_NUMBER, "list of X values to use for presentation mode breakpoint", "\"Thursday\" or [10, 54]").add(COLUMNS, PluginParamType.LIST_OR_SINGLE_STRING, "columns to display");
    }

    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.fullPath = componentsRegistry.resourceResolver().fullPath(pluginParams.getFreeParam());
        String csvContent = componentsRegistry.resourceResolver().textContent(this.fullPath);
        return ChartPluginResult.create(pluginParams, this.type(), csvContent);
    }

    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime((Path)this.fullPath));
    }
}

