/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.cli;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.utils.FileUtils;
import org.testingisdocumenting.znai.utils.ResourceUtils;

public class DocScaffolding {
    private final Path workingDir;
    private Map<String, List<String>> fileNameByDirName;

    public DocScaffolding(Path workingDir) {
        this.workingDir = workingDir;
        this.fileNameByDirName = new LinkedHashMap<String, List<String>>();
    }

    public void create() {
        this.createPages();
        this.createToc();
        this.createAuxiliaryContentFiles();
        this.createMeta();
        this.createIndex();
        this.createLookupPaths();
    }

    private void createLookupPaths() {
        this.createFileFromResource("lookup-paths");
    }

    private void createMeta() {
        this.createFileFromResource("meta.json");
    }

    private void createIndex() {
        this.createFileFromResource("index.md");
    }

    private void createPages() {
        this.createPage("chapter-one", "getting-started");
        this.createPage("chapter-one", "page-two");
        this.createPage("chapter-two", "page-three");
        this.createPage("chapter-two", "page-four");
    }

    private void createToc() {
        String toc = this.fileNameByDirName.keySet().stream().map(this::buildTocSection).collect(Collectors.joining("\n"));
        FileUtils.writeTextContent((Path)this.workingDir.resolve("toc"), (String)toc);
    }

    private void createAuxiliaryContentFiles() {
        this.createAuxiliaryContentFile("file-name.js");
    }

    private void createFileFromResource(String fileName) {
        FileUtils.writeTextContent((Path)this.workingDir.resolve(fileName), (String)ResourceUtils.textContent((String)fileName));
    }

    private String buildTocSection(String dirName) {
        List<String> fileNames = this.fileNameByDirName.get(dirName);
        return dirName + "\n    " + String.join((CharSequence)"\n    ", fileNames);
    }

    private void createPage(String dirName, String fileName) {
        this.registerPage(dirName, fileName);
        String withExtension = fileName + ".md";
        FileUtils.writeTextContent((Path)this.workingDir.resolve(dirName).resolve(withExtension), (String)ResourceUtils.textContent((String)withExtension));
    }

    private void registerPage(String dirName, String fileName) {
        List fileNames = this.fileNameByDirName.computeIfAbsent(dirName, k -> new ArrayList());
        fileNames.add(fileName);
    }

    private void createAuxiliaryContentFile(String resourceFilePath) {
        FileUtils.writeTextContent((Path)this.workingDir.resolve(resourceFilePath), (String)ResourceUtils.textContent((String)resourceFilePath));
    }
}

