/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.cli;

import io.vertx.core.http.HttpServer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import org.testingisdocumenting.znai.cli.DocScaffolding;
import org.testingisdocumenting.znai.cli.ZnaiCliConfig;
import org.testingisdocumenting.znai.cli.extension.CliCommandConfig;
import org.testingisdocumenting.znai.console.ConsoleOutput;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.AnsiConsoleOutput;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.html.reactjs.ReactJsBundle;
import org.testingisdocumenting.znai.server.AuthenticationHandler;
import org.testingisdocumenting.znai.server.AuthorizationHeaderBasedAuthenticationHandler;
import org.testingisdocumenting.znai.server.HttpServerUtils;
import org.testingisdocumenting.znai.server.ZnaiServer;
import org.testingisdocumenting.znai.server.preview.DocumentationPreview;
import org.testingisdocumenting.znai.utils.FileUtils;
import org.testingisdocumenting.znai.website.ProgressReporter;
import org.testingisdocumenting.znai.website.WebResource;
import org.testingisdocumenting.znai.website.WebSite;
import org.testingisdocumenting.znai.website.modifiedtime.ConstantPageModifiedTime;
import org.testingisdocumenting.znai.website.modifiedtime.FileBasedPageModifiedTime;
import org.testingisdocumenting.znai.website.modifiedtime.PageModifiedTimeStrategy;

public class ZnaiCliApp {
    private final ZnaiCliConfig config;
    private final Path deployPath;
    private WebSite webSite;
    private ReactJsBundle reactJsBundle;

    public ZnaiCliApp(ZnaiCliConfig cliConfig) {
        System.setProperty("java.awt.headless", "true");
        this.config = cliConfig;
        this.deployPath = this.config.getDeployRoot().resolve(this.getDocId());
    }

    public static void start(ZnaiCliConfig cliConfig) {
        ZnaiCliApp cliApp = new ZnaiCliApp(cliConfig);
        cliApp.start();
    }

    public static void main(String[] args) {
        ConsoleOutputs.add((ConsoleOutput)new AnsiConsoleOutput());
        ZnaiCliApp.start(new ZnaiCliConfig(args));
    }

    private String getDocId() {
        if (this.config.isPreviewMode()) {
            return "preview";
        }
        return this.config.getDocId();
    }

    private void start() {
        this.config.print();
        if (this.config.isScaffoldMode()) {
            this.createNew();
            return;
        }
        this.announceMode(this.config.getModeAsString());
        this.reactJsBundle = new ReactJsBundle();
        if (!this.config.isServeMode()) {
            this.generateDocs();
        }
        if (this.config.isPreviewMode()) {
            this.preview();
        } else if (this.config.isServeMode()) {
            this.serve();
        } else if (this.config.isExportMode()) {
            this.export();
        } else if (this.config.isCustomCommand()) {
            this.config.getSpecifiedCustomCommand().handle(new CliCommandConfig(this.config.getDocId(), this.config.getSourceRoot(), this.config.getDeployRoot(), this.config.getActor()));
        }
    }

    private void preview() {
        DocumentationPreview preview = new DocumentationPreview(this.config.getDeployRoot());
        preview.start(this.webSite, this.config.getPort().intValue(), () -> ZnaiCliApp.reportHostPort(this.config.getPort(), "/preview"));
    }

    private void serve() {
        HttpServer server = new ZnaiServer(this.reactJsBundle, this.config.getDeployRoot(), (AuthenticationHandler)new AuthorizationHeaderBasedAuthenticationHandler()).create();
        HttpServerUtils.listen((HttpServer)server, (int)this.config.getPort());
        ZnaiCliApp.reportHostPort(this.config.getPort(), "");
    }

    public void export() {
        ProgressReporter.reportPhase((String)"export documentation files");
        ZnaiCliApp.copyDir(this.config.getSourceRoot(), this.config.getExportRoot());
        String artifactsDirName = "_artifacts";
        Path artifactsRoot = this.config.getExportRoot().resolve(artifactsDirName);
        ProgressReporter.reportPhase((String)"export files that are required but outside of documentation");
        this.webSite.getOutsideDocsRequestedResources().forEach((k, v) -> {
            Path dest = artifactsRoot.resolve((String)k);
            ZnaiCliApp.copyFile(v, dest);
        });
        ProgressReporter.reportPhase((String)"patching lookup-paths");
        Path lookupPath = this.config.getExportRoot().resolve("lookup-paths");
        FileUtils.writeTextContent((Path)lookupPath, (String)artifactsDirName);
    }

    private static void copyFile(Path source, Path target) {
        ConsoleOutputs.out((Object[])new Object[]{"copy ", Color.PURPLE, source, Color.YELLOW, " to ", Color.PURPLE, target});
        FileUtils.copyFile((Path)source, (Path)target);
    }

    public static void copyDir(Path source, Path target) {
        try {
            Files.walk(source, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(f -> ZnaiCliApp.copyFile(f, target.resolve(source.relativize((Path)f))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void generateDocs() {
        Path userDefinedFavicon = this.config.getSourceRoot().resolve("favicon.png");
        WebResource favIconResource = Files.exists(userDefinedFavicon, new LinkOption[0]) ? WebResource.withPath((Path)userDefinedFavicon, (String)"favicon.png") : WebResource.fromResource((String)"favicon.png");
        WebSite.Configuration webSiteCfg = WebSite.withRoot((Path)this.config.getSourceRoot()).withReactJsBundle(this.reactJsBundle).withId(this.getDocId()).withDocumentationType(this.config.getMarkupType()).withMetaFromJsonFile(this.config.getSourceRoot().resolve("meta.json")).withFileWithLookupPaths("lookup-paths").withAdditionalLookupPaths(this.config.getLookupPaths()).withFooterPath(this.config.getSourceRoot().resolve("footer.md")).withExtensionsDefPath(this.config.getSourceRoot().resolve("extensions.json")).withGlobalReferencesPath(this.config.getSourceRoot().resolve("references.csv")).withWebResources(new WebResource[]{favIconResource}).withPageModifiedTimeStrategy(this.pageModifiedTimeStrategy()).withEnabledPreview(this.config.isPreviewMode());
        this.webSite = this.config.isExportMode() ? webSiteCfg.parseOnly() : webSiteCfg.deployTo(this.deployPath);
    }

    private PageModifiedTimeStrategy pageModifiedTimeStrategy() {
        switch (this.config.getModifiedTimeStrategy()) {
            case FILE: {
                return new FileBasedPageModifiedTime();
            }
            case CONSTANT: {
                return new ConstantPageModifiedTime(Instant.now());
            }
        }
        return null;
    }

    private void createNew() {
        Path pathToScaffold = (this.config.isSourceRootSet() ? this.config.getSourceRoot() : Paths.get("znai", new String[0])).toAbsolutePath();
        ConsoleOutputs.out((Object[])new Object[]{Color.BLUE, "scaffolding new documentation: ", Color.PURPLE, pathToScaffold});
        DocScaffolding scaffolding = new DocScaffolding(pathToScaffold);
        scaffolding.create();
    }

    private void announceMode(String name) {
        ConsoleOutputs.out((Object[])new Object[]{Color.BLUE, "znai ", Color.YELLOW, name + " mode"});
    }

    private static void reportHostPort(int port, String relativeUrl) {
        try {
            ConsoleOutputs.out((Object[])new Object[]{"http://", InetAddress.getLocalHost().getHostName(), ":", port, relativeUrl.isEmpty() ? "" : relativeUrl});
        }
        catch (UnknownHostException e) {
            ConsoleOutputs.err((Object[])new Object[]{"Cannot extract host name"});
        }
    }
}

