/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.diagrams.graphviz;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.diagrams.DiagramsGlobalAssetsRegistration;
import org.testingisdocumenting.znai.diagrams.graphviz.Graphviz;
import org.testingisdocumenting.znai.diagrams.graphviz.GraphvizDiagram;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;

public class GvDiagramIncludePlugin
implements IncludePlugin {
    public String id() {
        return "gv-diagram";
    }

    public IncludePlugin create() {
        return new GvDiagramIncludePlugin();
    }

    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        String diagramId = pluginParams.getFreeParam();
        String diagramPath = pluginParams.getOpts().getRequiredString("diagramPath");
        String gvContent = componentsRegistry.resourceResolver().textContent(diagramPath);
        DiagramsGlobalAssetsRegistration.register(componentsRegistry.globalAssetsRegistry());
        GraphvizDiagram diagram = Graphviz.graphvizEngine.diagramFromGv((String)pluginParams.getOpts().get("type", (Object)"dot"), diagramId, gvContent);
        LinkedHashMap<String, Map<String, Object>> props = new LinkedHashMap<String, Map<String, Object>>();
        props.put("diagram", diagram.toMap());
        return PluginResult.docElement((String)"GraphVizDiagram", props);
    }
}

