/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.diagrams.graphviz;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.diagrams.graphviz.GraphvizDiagram;
import org.testingisdocumenting.znai.diagrams.graphviz.GraphvizRuntime;
import org.testingisdocumenting.znai.diagrams.graphviz.meta.GraphvizDiagramWithMeta;
import org.testingisdocumenting.znai.diagrams.graphviz.meta.GraphvizShapeConfig;

public class GraphvizEngine {
    public static final String DOT_LAYOUT = "dot";
    private final GraphvizShapeConfig shapeConfig;
    private final Map<String, GraphvizRuntime> runtimeByType;

    public GraphvizEngine(GraphvizShapeConfig shapeConfig) {
        this.shapeConfig = shapeConfig;
        this.runtimeByType = new HashMap<String, GraphvizRuntime>();
    }

    public GraphvizDiagram diagramFromGv(String layoutType, String id, String gv) {
        GraphvizRuntime runtime = this.findGraphvizRuntime(layoutType);
        GraphvizDiagramWithMeta withMeta = GraphvizDiagramWithMeta.create(this.shapeConfig, gv);
        String graphSvg = runtime.svgFromGv(withMeta.getPreprocessed());
        Set<String> styles = withMeta.getStylesById().values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        LinkedHashMap<String, Boolean> isInvertedTextColorByStyleId = new LinkedHashMap<String, Boolean>();
        styles.forEach(s -> {
            boolean isInverted = this.shapeConfig.isInvertedTextColorByStyleId((String)s);
            if (isInverted) {
                isInvertedTextColorByStyleId.put((String)s, isInverted);
            }
        });
        return new GraphvizDiagram(id, graphSvg, withMeta.getStylesById(), isInvertedTextColorByStyleId);
    }

    private GraphvizRuntime findGraphvizRuntime(String layoutType) {
        GraphvizRuntime runtime = this.runtimeByType.get(layoutType);
        if (runtime == null) {
            throw new RuntimeException("no runtime found for layout type <" + layoutType + ">");
        }
        return runtime;
    }

    public GraphvizEngine registerRuntime(GraphvizRuntime runtime) {
        this.runtimeByType.put(runtime.getLayoutType(), runtime);
        return this;
    }
}

