/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.doxygen.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenMember;

public class DoxygenMembersList {
    private final List<DoxygenMember> members;

    public DoxygenMembersList() {
        this.members = new ArrayList<DoxygenMember>();
    }

    public DoxygenMembersList(Stream<DoxygenMember> memberStream) {
        this.members = memberStream.collect(Collectors.toList());
    }

    public void add(DoxygenMember member) {
        this.members.add(member);
    }

    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    public void forEach(Consumer<DoxygenMember> consumer) {
        this.members.forEach(consumer);
    }

    public DoxygenMember first() {
        return this.members.get(0);
    }

    public DoxygenMember findByArgs(String args) {
        String normalizedArg = DoxygenMembersList.normalizeArgs(args);
        return this.members.stream().filter(member -> member.matchesArgs(normalizedArg)).findFirst().orElse(null);
    }

    public String renderAvailableArgs() {
        return this.members.stream().map(DoxygenMember::getNormalizedParamsSignature).collect(Collectors.joining("\n"));
    }

    private static String normalizeArgs(String args) {
        return args.trim().replaceAll(",\\s+", ",").replaceAll("\\s+", " ").replaceAll(" &", "&").replaceAll(" \\*", "*");
    }
}

