/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.doxygen.parser;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenReturn;
import org.testingisdocumenting.znai.parser.docelement.DocElementCreationParserHandler;
import org.testingisdocumenting.znai.reference.DocReferences;
import org.testingisdocumenting.znai.utils.XmlUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DoxygenReturnParser {
    private final ComponentsRegistry componentsRegistry;
    private final List<String> textParts;
    private DocElementCreationParserHandler parserHandler;

    private DoxygenReturnParser(ComponentsRegistry componentsRegistry) {
        this.componentsRegistry = componentsRegistry;
        this.textParts = new ArrayList<String>();
    }

    public static DoxygenReturn parse(ComponentsRegistry componentsRegistry, Node node) {
        DoxygenReturnParser parser = new DoxygenReturnParser(componentsRegistry);
        return parser.parse(node);
    }

    private DoxygenReturn parse(Node node) {
        this.parserHandler = new DocElementCreationParserHandler(this.componentsRegistry, Paths.get("doxygen-xml", new String[0]));
        this.parseChildren(node);
        this.parserHandler.onParsingEnd();
        return new DoxygenReturn(this.parserHandler.getDocElement().getContent(), String.join((CharSequence)" ", this.textParts));
    }

    private void parseChildren(Node node) {
        XmlUtils.forEach((NodeList)node.getChildNodes(), this::handleRichTextNode);
    }

    private void handleRichTextNode(Node node) {
        String textContent;
        String textContentTrimmed;
        String nodeName = node.getNodeName();
        if (nodeName.equals("para")) {
            this.parserHandler.onParagraphStart();
            this.parseChildren(node);
            this.parserHandler.onParagraphEnd();
        } else if (nodeName.equals("computeroutput")) {
            String textContent2 = node.getTextContent();
            this.parserHandler.onInlinedCode(textContent2, DocReferences.EMPTY);
            this.textParts.add(textContent2);
        } else if (nodeName.equals("bold")) {
            this.parserHandler.onStrongEmphasisStart();
            this.parseChildren(node);
            this.parserHandler.onStrongEmphasisEnd();
        } else if (nodeName.equals("emphasis")) {
            this.parserHandler.onEmphasisStart();
            this.parseChildren(node);
            this.parserHandler.onEmphasisEnd();
        } else if (node.getNodeType() == 3 && !(textContentTrimmed = (textContent = node.getTextContent()).trim()).isEmpty()) {
            this.parserHandler.onSimpleText(textContent);
            this.textParts.add(textContentTrimmed);
        }
    }
}

