/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.doxygen.plugin;

import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.doxygen.Doxygen;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenMember;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenMembersList;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;

class DoxygenMemberListExtractor {
    static final String INCLUDE_ALL_MATCHES_KEY = "includeAllMatches";
    static final String ARGS_KEY = "args";

    DoxygenMemberListExtractor() {
    }

    static DoxygenMembersList extract(Doxygen doxygen, ComponentsRegistry componentsRegistry, PluginParamsOpts opts, boolean allowAll, String fullName) {
        DoxygenMembersList membersList;
        if (allowAll && opts.has(INCLUDE_ALL_MATCHES_KEY) && opts.has(ARGS_KEY)) {
            throw new IllegalArgumentException("can't specify includeAllMatches and args at the same time");
        }
        boolean includeAllMatches = allowAll && (Boolean)opts.get(INCLUDE_ALL_MATCHES_KEY, (Object)false) != false;
        String argsToFilter = (String)opts.get(ARGS_KEY, (Object)"");
        if (includeAllMatches) {
            membersList = doxygen.findAndParseAllMembers(componentsRegistry, fullName);
        } else if (!argsToFilter.isEmpty()) {
            membersList = doxygen.findAndParseAllMembers(componentsRegistry, fullName);
            DoxygenMember memberByArgs = membersList.findByArgs(argsToFilter);
            if (memberByArgs == null) {
                throw new RuntimeException("can't find member " + fullName + " with args: <" + argsToFilter + "> available args:\n" + membersList.renderAvailableArgs());
            }
            membersList = new DoxygenMembersList(Stream.of(memberByArgs));
        } else {
            membersList = new DoxygenMembersList(Stream.of(doxygen.getCachedOrFindAndParseMember(componentsRegistry, fullName)));
        }
        return membersList;
    }

    static void throwIfMembersListIsEmpty(Doxygen doxygen, ComponentsRegistry componentsRegistry, String fullName) {
        throw new RuntimeException("can't find member: " + fullName + ", available names:\n" + doxygen.buildIndexOrGetCached(componentsRegistry).renderAvailableMemberNames());
    }
}

