/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.java.extensions;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.api.ApiLinkedText;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.extensions.features.PluginFeature;
import org.testingisdocumenting.znai.extensions.file.CodeReferencesFeature;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.java.extensions.JavaDocMarkdownParameter;
import org.testingisdocumenting.znai.java.extensions.JavaIncludePluginBase;
import org.testingisdocumenting.znai.java.extensions.JavaIncludeResult;
import org.testingisdocumenting.znai.java.parser.EnumEntry;
import org.testingisdocumenting.znai.java.parser.JavaCode;

public class JavaEnumEntriesIncludePlugin
extends JavaIncludePluginBase {
    private static final String EXCLUDE_DEPRECATED_KEY = "excludeDeprecated";
    private CodeReferencesFeature codeReferencesFeature;

    public String id() {
        return "java-enum-entries";
    }

    public IncludePlugin create() {
        return new JavaEnumEntriesIncludePlugin();
    }

    public PluginParamsDefinition parameters() {
        return new PluginParamsDefinition().add("title", PluginParamType.STRING, "title to use for parameters block", "\"myMethod parameters\"").add(JavaDocMarkdownParameter.definition).add(EXCLUDE_DEPRECATED_KEY, PluginParamType.BOOLEAN, "exclude deprecated entries from the list", "true").add(CodeReferencesFeature.paramsDefinition);
    }

    @Override
    public JavaIncludeResult process(JavaCode javaCode) {
        this.codeReferencesFeature = new CodeReferencesFeature(this.componentsRegistry, this.markupPath, this.pluginParams);
        this.features.add((PluginFeature)this.codeReferencesFeature);
        ApiParameters apiParameters = new ApiParameters(this.determineAnchorPrefix());
        javaCode.getEnumEntries().stream().filter(this::includeEnum).forEach(enumEntry -> {
            JavaIncludePluginBase.JavaDocElementsMapsAndSearchText elementsMapsAndSearchText = this.javaDocTextToDocElements(enumEntry.getJavaDocText(), this.codeReferencesFeature);
            apiParameters.add(enumEntry.getName(), new ApiLinkedText(), elementsMapsAndSearchText.docElementsMaps, elementsMapsAndSearchText.searchText);
        });
        Map props = apiParameters.toMap();
        this.features.updateProps(props);
        props.putAll(this.pluginParams.getOpts().toMap());
        List docElements = PluginResult.docElement((String)"ApiParameters", (Map)props).getDocElements();
        return new JavaIncludeResult(docElements, this.extractText(javaCode.getEnumEntries()));
    }

    private boolean includeEnum(EnumEntry enumEntry) {
        boolean excludeDeprecated = (Boolean)this.pluginParams.getOpts().get(EXCLUDE_DEPRECATED_KEY, (Object)false);
        return !excludeDeprecated || !enumEntry.isDeprecated();
    }

    private String extractText(List<EnumEntry> enums) {
        return enums.stream().map(e -> e.getName() + " " + e.getJavaDocText()).collect(Collectors.joining(" "));
    }

    private String determineAnchorPrefix() {
        if (!this.entries.isEmpty()) {
            return (String)this.entries.get(0);
        }
        return this.fullPath.getFileName().toString();
    }
}

