/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.openapi;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.openapi.OpenApiOperation;
import org.testingisdocumenting.znai.openapi.OpenApiSpec;
import org.testingisdocumenting.znai.parser.ParserHandler;

public class OpenApiIncludePlugin
implements IncludePlugin {
    private Path specPath;
    private List<OpenApiOperation> operations = new ArrayList<OpenApiOperation>();
    private PluginParams pluginParams;
    private OpenApiSpec openApiSpec;
    private ParserHandler parserHandler;

    public String id() {
        return "open-api";
    }

    public IncludePlugin create() {
        return new OpenApiIncludePlugin();
    }

    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.pluginParams = pluginParams;
        this.parserHandler = parserHandler;
        this.specPath = componentsRegistry.resourceResolver().fullPath(pluginParams.getFreeParam());
        String specContent = componentsRegistry.resourceResolver().textContent(this.specPath);
        this.openApiSpec = this.isJson(specContent) ? OpenApiSpec.fromJson(componentsRegistry.markdownParser(), specContent) : OpenApiSpec.fromYaml(componentsRegistry.markdownParser(), specContent);
        this.findOperations();
        this.processOperations();
        return PluginResult.docElements(Stream.empty());
    }

    private boolean isJson(String specContent) {
        return specContent.trim().startsWith("{");
    }

    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime((Path)this.specPath));
    }

    private void findOperations() {
        String operationId = (String)this.pluginParams.getOpts().get("operationId");
        String method = (String)this.pluginParams.getOpts().get("method", (Object)"");
        String path = (String)this.pluginParams.getOpts().get("path", (Object)"");
        List tags = this.pluginParams.getOpts().getList("tags");
        if (path.isEmpty() && !method.isEmpty() || !path.isEmpty() && method.isEmpty()) {
            throw new IllegalArgumentException("both method and path needs to be specified to find Open API operation");
        }
        if (!path.isEmpty()) {
            this.operations.add(this.openApiSpec.findOperationByMethodAndPath(method, path));
        }
        if (operationId != null) {
            this.operations.add(this.openApiSpec.findOperationById(operationId));
        }
        if (!tags.isEmpty()) {
            this.operations.addAll(this.openApiSpec.findOperationsByTags(tags));
        }
    }

    private void processOperations() {
        boolean isAutoSection = (Boolean)this.pluginParams.getOpts().get("autoSection", (Object)false);
        this.operations.forEach(operation -> this.processOperation((OpenApiOperation)operation, isAutoSection));
    }

    private void processOperation(OpenApiOperation operation, boolean isAutoSection) {
        if (isAutoSection) {
            this.parserHandler.onSectionStart(operation.getSummary());
        }
        Map props = this.pluginParams.getOpts().toMap();
        props.put("operation", operation.toMap());
        this.parserHandler.onCustomNode("OpenApiOperation", props);
    }
}

