/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.openapi;

import java.util.LinkedHashMap;
import java.util.Map;
import org.testingisdocumenting.znai.openapi.OpenApi3Schema;

public class OpenApi3Content {
    private final Map<String, OpenApi3Schema> schemaByMimeType = new LinkedHashMap<String, OpenApi3Schema>();
    private final Map<String, String> exampleByMimeType = new LinkedHashMap<String, String>();

    public void register(String mimeType, OpenApi3Schema schema, Object example) {
        this.schemaByMimeType.put(mimeType, schema);
        if (example != null) {
            this.exampleByMimeType.put(mimeType, example.toString());
        }
    }

    public Map<String, OpenApi3Schema> getSchemaByMimeType() {
        return this.schemaByMimeType;
    }

    public String exampleByMimeType(String mimeType) {
        return this.exampleByMimeType.getOrDefault(mimeType, "");
    }

    public boolean isEmpty() {
        return this.schemaByMimeType.isEmpty();
    }
}

