/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.openapi;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.openapi.OpenApi3Content;
import org.testingisdocumenting.znai.openapi.OpenApi3Operation;
import org.testingisdocumenting.znai.openapi.OpenApi3Parameter;
import org.testingisdocumenting.znai.openapi.OpenApi3ParametersToApiParametersConverter;
import org.testingisdocumenting.znai.openapi.OpenApi3Response;
import org.testingisdocumenting.znai.openapi.OpenApi3Schema;
import org.testingisdocumenting.znai.openapi.OpenApi3SchemaToApiParametersConverter;
import org.testingisdocumenting.znai.openapi.OpenApi3Spec;
import org.testingisdocumenting.znai.openapi.OpenApiMarkdownParser;
import org.testingisdocumenting.znai.parser.HeadingProps;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.parser.commonmark.MarkdownParser;
import org.testingisdocumenting.znai.parser.docelement.DocElement;
import org.testingisdocumenting.znai.utils.CollectionUtils;

public class OpenApi3IncludePlugin
implements IncludePlugin {
    private static final String OPERATION_ID_KEY = "operationId";
    private static final String METHOD_KEY = "method";
    private static final String PATH_KEY = "path";
    private static final String AUTO_SECTION_KEY = "autoSection";
    private static final String TAGS_KEY = "tags";
    private Path specPath;
    private ParserHandler parserHandler;
    private OpenApi3Spec spec;
    private MarkdownParser markdownParser;
    private OpenApiMarkdownParser openApiMarkdownParser;

    public String id() {
        return "open-api";
    }

    public IncludePlugin create() {
        return new OpenApi3IncludePlugin();
    }

    public PluginParamsDefinition parameters() {
        return new PluginParamsDefinition().add(OPERATION_ID_KEY, PluginParamType.STRING, "operation ID to find operation", "findUserById").add(METHOD_KEY, PluginParamType.STRING, "method to find operation", "post").add(PATH_KEY, PluginParamType.STRING, "path to find operation", "/user").add(TAGS_KEY, PluginParamType.STRING, "tags to find operation", "[\"pet\"]").add(AUTO_SECTION_KEY, PluginParamType.BOOLEAN, "auto generate page section for the operation", "true");
    }

    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.markdownParser = componentsRegistry.markdownParser();
        this.parserHandler = parserHandler;
        this.openApiMarkdownParser = description -> this.markdownParser.parse(markupPath, description).getDocElement();
        this.specPath = componentsRegistry.resourceResolver().fullPath(pluginParams.getFreeParam());
        String specContent = componentsRegistry.resourceResolver().textContent(this.specPath);
        this.spec = OpenApi3Spec.parse(specContent);
        List<OpenApi3Operation> operations = this.findOperations(pluginParams);
        this.validateOperations(operations);
        operations.forEach(operation -> this.renderOperation((OpenApi3Operation)operation, pluginParams));
        return PluginResult.docElements(Stream.empty());
    }

    private void validateOperations(List<OpenApi3Operation> operations) {
        if (operations.isEmpty()) {
            throw new IllegalArgumentException("can't find open api operation(s), make sure provided operationId, method, path, tags are set correctly");
        }
    }

    private void renderOperation(OpenApi3Operation operation, PluginParams pluginParams) {
        this.renderSectionIfRequired(operation, pluginParams);
        this.renderUrl(operation);
        this.renderDescription(operation.getDescription());
        this.renderParameters(operation);
        this.renderRequests(operation);
        this.renderResponses(operation);
    }

    private List<OpenApi3Operation> findOperations(PluginParams pluginParams) {
        String operationId = (String)pluginParams.getOpts().get(OPERATION_ID_KEY);
        if (operationId != null) {
            return this.findOperationByOperationId(operationId);
        }
        List tags = pluginParams.getOpts().getList(TAGS_KEY);
        if (!tags.isEmpty()) {
            return this.findOperationsByTags(tags);
        }
        return this.findOperationByMethodAndPath(pluginParams);
    }

    private List<OpenApi3Operation> findOperationByOperationId(String operationId) {
        OpenApi3Operation result = this.spec.findById(operationId);
        if (result == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(result);
    }

    private List<OpenApi3Operation> findOperationByMethodAndPath(PluginParams pluginParams) {
        String path;
        String method = (String)pluginParams.getOpts().get(METHOD_KEY, (Object)"");
        OpenApi3Operation result = this.spec.findByMethodAndPath(method, path = (String)pluginParams.getOpts().get(PATH_KEY, (Object)""));
        if (result == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(result);
    }

    private List<OpenApi3Operation> findOperationsByTags(List<String> tags) {
        return this.spec.findOperationsByTags(tags);
    }

    private void renderSectionIfRequired(OpenApi3Operation operation, PluginParams pluginParams) {
        if (!((Boolean)pluginParams.getOpts().get(AUTO_SECTION_KEY, (Object)false)).booleanValue()) {
            return;
        }
        if (operation.getSummary() == null || operation.getSummary().trim().isEmpty()) {
            throw new IllegalArgumentException("summary is missing for operation <" + operation.getId() + ">");
        }
        this.parserHandler.onSectionStart(operation.getSummary(), HeadingProps.EMPTY);
    }

    private void renderUrl(OpenApi3Operation operation) {
        this.parserHandler.onCustomNode("OpenApiMethodAndUrl", CollectionUtils.createMap((Object[])new Object[]{METHOD_KEY, operation.getMethod(), "url", operation.getPath()}));
    }

    private void renderRequests(OpenApi3Operation operation) {
        if (operation.getRequest() == null) {
            return;
        }
        this.parserHandler.onSubHeading(2, "Request", HeadingProps.STYLE_API);
        this.renderDescription(operation.getRequest().getDescription());
        this.renderContent(operation, operation.getRequest().getContent());
    }

    private void renderResponses(OpenApi3Operation operation) {
        if (operation.getResponses().isEmpty()) {
            return;
        }
        this.parserHandler.onSubHeading(2, this.renderResponsesTitle(operation), HeadingProps.STYLE_API);
        for (OpenApi3Response response : operation.getResponses()) {
            this.parserHandler.onSubHeading(4, response.getCode(), HeadingProps.STYLE_API);
            this.renderDescription(response.getDescription());
            this.renderContent(operation, response.getContent());
        }
    }

    private String renderResponsesTitle(OpenApi3Operation operation) {
        return "Response" + (operation.getResponses().size() > 1 ? "s" : "");
    }

    private void renderContent(OpenApi3Operation operation, OpenApi3Content content) {
        if (content.getSchemaByMimeType().isEmpty()) {
            return;
        }
        ArrayList schemasWithCollapsed = new ArrayList();
        Map<String, OpenApi3Schema> byMimeType = content.getSchemaByMimeType();
        byMimeType.forEach((mimeType, schema) -> schemasWithCollapsed.add(new SchemaWithCollapsedAndExample((String)mimeType, (OpenApi3Schema)schema, true, content.exampleByMimeType((String)mimeType))));
        int jsonIdx = IntStream.range(0, schemasWithCollapsed.size()).filter(idx -> ((SchemaWithCollapsedAndExample)schemasWithCollapsed.get(idx)).mimeType.equals("application/json")).findFirst().orElse(-1);
        if (jsonIdx != -1) {
            Collections.swap(schemasWithCollapsed, jsonIdx, 0);
        }
        ((SchemaWithCollapsedAndExample)schemasWithCollapsed.get(0)).collapsed = false;
        schemasWithCollapsed.forEach(schemaWithCollapsedAndExample -> this.renderSchema(operation, (SchemaWithCollapsedAndExample)schemaWithCollapsedAndExample));
    }

    private void renderDescription(String description) {
        if (description == null) {
            return;
        }
        DocElement docElement = this.openApiMarkdownParser.docElementFromDescription(description);
        docElement.getContent().forEach(arg_0 -> ((ParserHandler)this.parserHandler).onDocElement(arg_0));
    }

    private void renderParameters(OpenApi3Operation operation) {
        List<OpenApi3Parameter> parameters = operation.getParameters();
        this.renderParametersWithTitle(operation, parameters.stream().filter(p -> p.getIn().equals(PATH_KEY)), "path parameters");
        this.renderParametersWithTitle(operation, parameters.stream().filter(p -> p.getIn().equals("query")), "query parameters");
    }

    private void renderParametersWithTitle(OpenApi3Operation operation, Stream<OpenApi3Parameter> parametersStream, String title) {
        List<OpenApi3Parameter> parameters = parametersStream.collect(Collectors.toList());
        if (parameters.isEmpty()) {
            return;
        }
        ApiParameters apiParameters = new OpenApi3ParametersToApiParametersConverter(this.openApiMarkdownParser, operation.getId(), parameters).convert();
        Map props = apiParameters.toMap();
        props.put("title", title);
        props.put("collapsed", false);
        props.put("noGap", true);
        this.parserHandler.onCustomNode("ApiParameters", props);
    }

    private void renderSchema(OpenApi3Operation operation, SchemaWithCollapsedAndExample schemaWithCollapsedAndExample) {
        ApiParameters apiParameters = new OpenApi3SchemaToApiParametersConverter(this.openApiMarkdownParser, operation.getId() + schemaWithCollapsedAndExample.mimeType, schemaWithCollapsedAndExample.schema).convert();
        if (!schemaWithCollapsedAndExample.example.isEmpty()) {
            apiParameters.setExample(schemaWithCollapsedAndExample.example);
        }
        Map props = apiParameters.toMap();
        props.put("title", schemaWithCollapsedAndExample.mimeType);
        props.put("collapsed", schemaWithCollapsedAndExample.collapsed);
        props.put("noGap", true);
        this.parserHandler.onCustomNode("ApiParameters", props);
    }

    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime((Path)this.specPath));
    }

    private static class SchemaWithCollapsedAndExample {
        private final String mimeType;
        private final OpenApi3Schema schema;
        private boolean collapsed;
        private final String example;

        private SchemaWithCollapsedAndExample(String mimeType, OpenApi3Schema schema, boolean collapsed, String example) {
            this.mimeType = mimeType;
            this.schema = schema;
            this.collapsed = collapsed;
            this.example = example;
        }
    }
}

