/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.openapi;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.utils.StringUtils;

public class OpenApi3Schema {
    private static final String ADDITIONAL_PROPS_NAME = "< * >";
    private final String name;
    private final String type;
    private final String description;
    private final List<OpenApi3Schema> properties;
    private final List<String> required;
    private String title;
    private String format;
    private Object example;
    private String defaultRendered;
    private List<String> enumValues;
    private OpenApi3Schema items;
    private OpenApi3Schema additionalProperties;

    public static OpenApi3Schema convertFromParsed(String name, Schema<?> parsed) {
        if (parsed instanceof ComposedSchema) {
            return OpenApi3Schema.convertFromComposed(name, (ComposedSchema)parsed);
        }
        if (parsed instanceof ObjectSchema) {
            return OpenApi3Schema.convertFromObject(name, (Schema<Object>)((ObjectSchema)parsed));
        }
        if (parsed instanceof MapSchema) {
            return OpenApi3Schema.convertFromMap(name, (MapSchema)parsed);
        }
        if (parsed instanceof ArraySchema) {
            return OpenApi3Schema.convertFromArray(name, (ArraySchema)parsed);
        }
        if (parsed instanceof StringSchema) {
            return OpenApi3Schema.convertFromString(name, (StringSchema)parsed);
        }
        return OpenApi3Schema.defaultSchema(name, parsed);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Object getExample() {
        return this.example;
    }

    public void setExample(Object example) {
        this.example = example;
    }

    public boolean isRequired(String name) {
        return this.required.contains(name);
    }

    public String renderTypeWithFormatOrEnum() {
        String typeClassifier = this.renderTypeClassifier();
        return !typeClassifier.isEmpty() ? this.type + "(" + typeClassifier + ")" : this.type;
    }

    public String renderCombinedType() {
        if (this.getType().equals("array")) {
            return "array of " + this.getItems().renderTypeWithFormatOrEnum();
        }
        return this.renderTypeWithFormatOrEnum();
    }

    public String getDescription() {
        return this.description;
    }

    public String renderDescriptionWithExamplesAndEnums() {
        String titlePart;
        ArrayList<String> parts = new ArrayList<String>();
        String string = titlePart = this.title != null ? "#### " + this.title : "";
        if (titlePart.isEmpty() && !this.description.isEmpty()) {
            parts.add(this.description);
        } else if (!titlePart.isEmpty() && this.description.isEmpty()) {
            parts.add(titlePart);
        } else if (!titlePart.isEmpty()) {
            parts.add(titlePart + "\n\n" + this.description);
        }
        if (this.example != null) {
            parts.add(this.renderExample());
        }
        if (this.enumValues != null) {
            parts.add(this.renderEnumValues());
        }
        return String.join((CharSequence)"\n\\\n", parts);
    }

    public String renderTypeClassifier() {
        if (this.format != null) {
            return this.format;
        }
        if (this.enumValues != null) {
            return "enum";
        }
        return "";
    }

    private String renderEnumValues() {
        if (this.enumValues == null) {
            return "";
        }
        return "*Available Values*: " + this.enumValues.stream().map(v -> "`" + v + "`").collect(Collectors.joining(", "));
    }

    public String renderExample() {
        return this.example != null ? "*Example*: `" + this.example + "`" : "";
    }

    public OpenApi3Schema getItems() {
        return this.items;
    }

    void setItems(OpenApi3Schema items) {
        this.items = items;
    }

    public OpenApi3Schema getAdditionalProperties() {
        return this.additionalProperties;
    }

    public List<OpenApi3Schema> getProperties() {
        return this.properties;
    }

    public List<String> getRequired() {
        return this.required;
    }

    public void addRequired(List<String> names) {
        this.required.addAll(names);
    }

    OpenApi3Schema(String name, String type, String description) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.properties = new ArrayList<OpenApi3Schema>();
        this.required = new ArrayList<String>();
    }

    private static OpenApi3Schema convertFromComposed(String name, ComposedSchema parsed) {
        String composedType = OpenApi3Schema.composedType(parsed);
        OpenApi3Schema schema = OpenApi3Schema.createSchema(name, composedType, parsed);
        if (parsed.getOneOf() != null) {
            OpenApi3Schema.populateComposed(schema, composedType, parsed.getOneOf());
        } else if (parsed.getAnyOf() != null) {
            OpenApi3Schema.populateComposed(schema, composedType, parsed.getAnyOf());
        }
        return schema;
    }

    private static String composedType(ComposedSchema schema) {
        if (schema.getOneOf() != null) {
            return "oneOf";
        }
        if (schema.getAnyOf() != null) {
            return "anyOf";
        }
        return "unknown-composed-type";
    }

    private static void populateComposed(OpenApi3Schema parent, String composedType, List<Schema> list) {
        list.forEach(child -> parent.properties.add(OpenApi3Schema.convertFromParsed("", child)));
    }

    private static OpenApi3Schema convertFromObject(String name, Schema<Object> parsed) {
        OpenApi3Schema schema = OpenApi3Schema.createSchema(name, parsed);
        Map parsedProperties = parsed.getProperties();
        if (parsedProperties != null) {
            parsedProperties.forEach((propertyName, parsedSchema) -> schema.properties.add(OpenApi3Schema.convertFromParsed(propertyName, parsedSchema)));
        }
        if (parsed.getRequired() != null) {
            schema.required.addAll(parsed.getRequired());
        }
        return schema;
    }

    private static OpenApi3Schema convertFromMap(String name, MapSchema parsed) {
        OpenApi3Schema schema = OpenApi3Schema.convertFromObject(name, (Schema<Object>)parsed);
        if (parsed.getAdditionalProperties() == null) {
            return schema;
        }
        if (parsed.getAdditionalProperties() instanceof Boolean && parsed.getAdditionalProperties().equals(true)) {
            schema.additionalProperties = OpenApi3Schema.createAnyTypeSchema();
        } else if (parsed.getAdditionalProperties() instanceof Schema) {
            schema.additionalProperties = OpenApi3Schema.convertFromParsed(ADDITIONAL_PROPS_NAME, (Schema)parsed.getAdditionalProperties());
        }
        return schema;
    }

    private static OpenApi3Schema createAnyTypeSchema() {
        return new OpenApi3Schema(ADDITIONAL_PROPS_NAME, "any", "");
    }

    private static OpenApi3Schema convertFromArray(String name, ArraySchema parsed) {
        OpenApi3Schema result = OpenApi3Schema.createSchema(name, parsed);
        result.setItems(OpenApi3Schema.convertFromParsed("", parsed.getItems()));
        return result;
    }

    private static OpenApi3Schema convertFromString(String name, StringSchema parsed) {
        OpenApi3Schema result = OpenApi3Schema.createSchema(name, parsed);
        if (parsed.getEnum() != null) {
            result.enumValues = new ArrayList<String>(parsed.getEnum());
        }
        return result;
    }

    private static OpenApi3Schema defaultSchema(String name, Schema<?> parsed) {
        return OpenApi3Schema.createSchema(name, parsed);
    }

    private static OpenApi3Schema createSchema(String name, Schema<?> parsed) {
        return OpenApi3Schema.createSchema(name, parsed.getType(), parsed);
    }

    private static OpenApi3Schema createSchema(String name, String type, Schema<?> parsed) {
        OpenApi3Schema schema = new OpenApi3Schema(name, type, StringUtils.nullAsEmpty((Object)parsed.getDescription()));
        if (parsed.getTitle() != null) {
            schema.setTitle(parsed.getTitle());
        }
        if (parsed.getFormat() != null) {
            schema.setFormat(parsed.getFormat());
        }
        if (parsed.getExampleSetFlag()) {
            schema.setExample(parsed.getExample());
        }
        return schema;
    }
}

