/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.python;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.parser.docelement.DocElement;
import org.testingisdocumenting.znai.python.PythonIncludePluginBase;
import org.testingisdocumenting.znai.python.PythonIncludeResult;
import org.testingisdocumenting.znai.python.PythonParsedEntry;
import org.testingisdocumenting.znai.python.PythonParsedFile;

public class PythonDocParamsIncludePlugin
extends PythonIncludePluginBase {
    public String id() {
        return "python-doc-params";
    }

    public IncludePlugin create() {
        return new PythonDocParamsIncludePlugin();
    }

    @Override
    public PythonIncludeResult process(PythonParsedFile parsed, ParserHandler parserHandler, Path markupPath) {
        String entryName = this.getEntryName();
        PythonParsedEntry codeEntry = this.findEntryByName(parsed, entryName);
        ApiParameters apiParameters = codeEntry.createParametersFromPyDoc(this.componentsRegistry.docStructure(), (MarkupParser)this.componentsRegistry.markdownParser(), this.fullPath, entryName);
        Map props = apiParameters.toMap();
        this.codeReferencesFeature.updateProps(props);
        props.putAll(this.pluginParams.getOpts().toMap());
        List<DocElement> docElements = Collections.singletonList(DocElement.withPropsMap((String)"ApiParameters", (Map)props));
        return new PythonIncludeResult(docElements, codeEntry.getDocString());
    }
}

