/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.python;

import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.extensions.api.ApiLinkedText;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.python.PythonArg;
import org.testingisdocumenting.znai.python.PythonContext;
import org.testingisdocumenting.znai.python.PythonDocParam;
import org.testingisdocumenting.znai.python.PythonType;
import org.testingisdocumenting.znai.python.PythonUtils;
import org.testingisdocumenting.znai.python.pydoc.ParsedPythonDoc;
import org.testingisdocumenting.znai.python.pydoc.PythonDocReturn;
import org.testingisdocumenting.znai.structure.DocStructure;

public class PythonParsedEntry {
    private final PythonContext context;
    private final String name;
    private final String type;
    private final String content;
    private final String bodyOnly;
    private final String docString;
    private final List<PythonArg> args;
    private final PythonType returns;
    private final List<String> decorators;
    private final Map<String, Object> parsed;

    public PythonParsedEntry(Map<String, Object> parsed, PythonContext context) {
        this.context = context;
        this.parsed = parsed;
        this.name = Objects.toString(parsed.get("name"), "");
        this.type = Objects.toString(parsed.get("type"), "");
        this.content = Objects.toString(parsed.get("content"), "");
        this.bodyOnly = Objects.toString(parsed.get("body_only"), "");
        this.docString = Objects.toString(parsed.get("doc_string"), "");
        this.args = this.buildArgs(parsed);
        this.returns = this.buildReturns(parsed);
        this.decorators = this.extractDecorators(parsed);
    }

    public Map<String, Object> getParsed() {
        return this.parsed;
    }

    public boolean isFunction() {
        return this.type.equals("function");
    }

    public boolean isProperty() {
        return this.type.equals("property");
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public String getBodyOnly() {
        return this.bodyOnly;
    }

    public String getDocString() {
        return this.docString;
    }

    public List<PythonArg> getArgs() {
        return this.args;
    }

    public PythonType getReturns() {
        return this.returns;
    }

    public List<String> getDecorators() {
        return this.decorators;
    }

    public boolean isStatic() {
        return this.decorators.contains("staticmethod");
    }

    public boolean isClassMethod() {
        return this.decorators.contains("classmethod");
    }

    public boolean isPrivate() {
        String shortName = PythonUtils.entityNameFromQualifiedName(this.name);
        return shortName.startsWith("_") && !shortName.equals("__init__");
    }

    public Map<String, ?> toMap(DocStructure docStructure) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", this.name);
        map.put("type", this.type);
        map.put("args", this.args.stream().map(arg -> arg.toMap(docStructure)).collect(Collectors.toList()));
        map.put("returns", this.returns.convertToApiLinkedText(docStructure).toListOfMaps());
        map.put("decorators", this.decorators);
        return map;
    }

    public ApiParameters createParametersFromPyDoc(DocStructure docStructure, MarkupParser parser, Path parentMarkupPath, String anchorId) {
        ParsedPythonDoc parsedPythonDoc = new ParsedPythonDoc(this.getDocString());
        ApiParameters apiParameters = new ApiParameters(anchorId);
        PythonDocReturn funcReturn = parsedPythonDoc.getFuncReturn();
        if (funcReturn.isDefined()) {
            MarkupParserResult parsedMarkdown = parser.parse(parentMarkupPath, funcReturn.getPyDocText());
            apiParameters.add("returns", this.returnsType(docStructure, funcReturn), parsedMarkdown.contentToListOfMaps(), parsedMarkdown.getAllText());
        }
        parsedPythonDoc.getParams().forEach(pythonParam -> {
            MarkupParserResult parsedMarkdown = parser.parse(parentMarkupPath, pythonParam.getPyDocText());
            apiParameters.add(pythonParam.getName(), this.paramType(docStructure, (PythonDocParam)pythonParam), parsedMarkdown.contentToListOfMaps(), parsedMarkdown.getAllText());
        });
        return apiParameters;
    }

    private ApiLinkedText returnsType(DocStructure docStructure, PythonDocReturn funcReturn) {
        PythonType returnTypeHint = this.getReturns();
        return returnTypeHint.isDefined() ? returnTypeHint.convertToApiLinkedText(docStructure) : new ApiLinkedText(funcReturn.getType());
    }

    private ApiLinkedText paramType(DocStructure docStructure, PythonDocParam param) {
        PythonArg typeHint = this.getArgs().stream().filter(p -> param.getName().equals(p.getName())).findFirst().orElseThrow(() -> new IllegalArgumentException("no parameter <" + param.getName() + "> found is signature"));
        return typeHint.getType().isDefined() ? typeHint.getType().convertToApiLinkedText(docStructure) : new ApiLinkedText(param.getType());
    }

    private List<PythonArg> buildArgs(Map<String, Object> parsed) {
        Object parsedArgs = parsed.get("args");
        if (parsedArgs == null) {
            return Collections.emptyList();
        }
        List parsedArgsList = (List)parsedArgs;
        return parsedArgsList.stream().map(arg -> new PythonArg((Map<String, Object>)arg, this.context)).collect(Collectors.toList());
    }

    private PythonType buildReturns(Map<String, Object> parsed) {
        return new PythonType(parsed.get("returns"), this.context);
    }

    private List<String> extractDecorators(Map<String, Object> parsed) {
        Object decoratorsValue = parsed.get("decorators");
        return decoratorsValue == null ? Collections.emptyList() : (List)decoratorsValue;
    }
}

