/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.python;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.python.PythonClass;
import org.testingisdocumenting.znai.python.PythonContext;
import org.testingisdocumenting.znai.python.PythonParsedEntry;

public class PythonParsedFile {
    private final Map<String, PythonParsedEntry> entryByName;
    private final List<Map<String, Object>> parsed;
    private final PythonContext context;
    private final Map<String, PythonClass> classByName;

    public PythonParsedFile(List<Map<String, Object>> parsed, PythonContext context) {
        this.parsed = parsed;
        this.context = context;
        this.entryByName = new LinkedHashMap<String, PythonParsedEntry>();
        this.classByName = new HashMap<String, PythonClass>();
        this.handleEntriesAndReturnMembers(parsed);
    }

    public List<Map<String, Object>> getParsed() {
        return this.parsed;
    }

    public Stream<String> namesStream() {
        return this.entryByName.keySet().stream();
    }

    public PythonParsedEntry findEntryByName(String name) {
        return this.entryByName.get(name);
    }

    public PythonClass findClassByName(String name) {
        return this.classByName.get(name);
    }

    public PythonParsedEntry findRequiredEntryByTypeAndName(String type, String name) {
        PythonParsedEntry entry = this.findEntryByName(name);
        if (entry == null) {
            throw new IllegalArgumentException("can't find entry: " + name);
        }
        if (!entry.getType().equals(type)) {
            throw new IllegalArgumentException("found entry by name <" + name + "> is not a " + type + ", but <" + entry.getType() + ">");
        }
        return entry;
    }

    public List<PythonParsedEntry> findAllEntriesWithPrefix(String prefix) {
        return this.entryByName.values().stream().filter(e -> e.getName().startsWith(prefix)).collect(Collectors.toList());
    }

    public List<PythonParsedEntry> findAllEntriesByTypeWithPrefix(String type, String prefix) {
        return this.entryByName.values().stream().filter(e -> e.getType().equals(type) && e.getName().startsWith(prefix)).collect(Collectors.toList());
    }

    private List<PythonParsedEntry> handleEntriesAndReturnMembers(List<Map<String, Object>> parsed) {
        ArrayList<PythonParsedEntry> result = new ArrayList<PythonParsedEntry>();
        parsed.forEach(p -> {
            PythonParsedEntry entry = new PythonParsedEntry((Map<String, Object>)p, this.context);
            this.entryByName.put(entry.getName(), entry);
            if (entry.getType().equals("class")) {
                this.handleClass(entry, p.getOrDefault("members", Collections.emptyList()));
            } else {
                result.add(entry);
            }
        });
        return result;
    }

    private void handleClass(PythonParsedEntry entry, List<Map<String, Object>> parsedMembers) {
        PythonClass pythonClass = new PythonClass(entry.getName(), this.context);
        this.classByName.put(pythonClass.getName(), pythonClass);
        List<PythonParsedEntry> members = this.handleEntriesAndReturnMembers(parsedMembers);
        pythonClass.addMembers(members);
        pythonClass.addBaseClasses(entry.getParsed().getOrDefault("bases", Collections.emptyList()));
    }
}

