/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.python.pydoc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testingisdocumenting.znai.python.PythonDocParam;
import org.testingisdocumenting.znai.python.pydoc.PythonDocParser;
import org.testingisdocumenting.znai.python.pydoc.PythonDocParserResult;
import org.testingisdocumenting.znai.python.pydoc.PythonDocReturn;
import org.testingisdocumenting.znai.utils.StringUtils;

public class PythonDocPandasLikeParser
implements PythonDocParser {
    private final String PARAMETERS_HEADER = "Parameters";
    private final String RETURNS_HEADER = "Returns";
    private final String UNDERSCORE_PATTERN = "\\s+[-_]+";
    private final Pattern HEADER_START = Pattern.compile("\\w+\\s+[-_]+");
    private final Pattern PARAMETERS_START = Pattern.compile("Parameters\\s+[-_]+");
    private final Pattern PARAMETER_NAME_TYPE = Pattern.compile("^(\\S+)\\s*:\\s*(.*)\\s*");
    private final Pattern RETURNS_START = Pattern.compile("Returns\\s+[-_]+");
    private final List<PythonDocParam> params = new ArrayList<PythonDocParam>();
    private String currentName = "";
    private String currentType;
    private List<String> currentDocLines;

    @Override
    public boolean handles(String pyDoc) {
        if (pyDoc == null) {
            return false;
        }
        return this.HEADER_START.matcher(pyDoc).find();
    }

    @Override
    public PythonDocPandasLikeParser create() {
        return new PythonDocPandasLikeParser();
    }

    @Override
    public PythonDocParserResult parse(String pyDoc) {
        String descriptionOnly = this.extractDescriptionOnly(pyDoc);
        List<PythonDocParam> params = this.parseParams(pyDoc);
        PythonDocReturn funcReturn = this.parseReturn(pyDoc);
        return new PythonDocParserResult(descriptionOnly, params, funcReturn);
    }

    private String extractDescriptionOnly(String pyDoc) {
        Matcher matcher = this.HEADER_START.matcher(pyDoc);
        if (!matcher.find()) {
            return pyDoc;
        }
        return pyDoc.substring(0, matcher.start()).trim();
    }

    private List<PythonDocParam> parseParams(String pyDoc) {
        String line;
        LineHandleResult result;
        String[] lines;
        Matcher matcher = this.PARAMETERS_START.matcher(pyDoc);
        if (!matcher.find()) {
            return Collections.emptyList();
        }
        int start = matcher.start();
        String fromParams = pyDoc.substring(start);
        String[] stringArray = lines = fromParams.split("\n");
        int n = stringArray.length;
        for (int i = 0; i < n && (result = this.handleParamsLine(line = stringArray[i])) != LineHandleResult.BREAK; ++i) {
        }
        this.flushParamIfRequired();
        return Collections.unmodifiableList(this.params);
    }

    private PythonDocReturn parseReturn(String pyDoc) {
        Matcher matcher = this.RETURNS_START.matcher(pyDoc);
        if (!matcher.find()) {
            return PythonDocReturn.undefined();
        }
        int start = matcher.start();
        String fromReturns = pyDoc.substring(start);
        String[] lines = fromReturns.split("\n");
        if (lines.length < 3) {
            return PythonDocReturn.undefined();
        }
        String optionalTypeLine = lines[2];
        if (optionalTypeLine.startsWith(" ")) {
            return new PythonDocReturn("", this.extractTextUntilNextDelimiter(lines, 2));
        }
        return new PythonDocReturn(optionalTypeLine.trim(), this.extractTextUntilNextDelimiter(lines, 3));
    }

    private String extractTextUntilNextDelimiter(String[] lines, int startIdx) {
        String line;
        ArrayList<String> result = new ArrayList<String>();
        for (int idx = startIdx; idx < lines.length && ((line = lines[idx]).isEmpty() || line.startsWith(" ")); ++idx) {
            result.add(line.trim());
        }
        return String.join((CharSequence)"\n", result).trim();
    }

    private LineHandleResult handleParamsLine(String line) {
        String trimmed = line.trim();
        if (trimmed.equals("Parameters")) {
            return LineHandleResult.CONTINUE;
        }
        if (line.startsWith("___") || line.startsWith("---")) {
            return LineHandleResult.CONTINUE;
        }
        if (trimmed.isEmpty() && this.currentName.isEmpty()) {
            return LineHandleResult.CONTINUE;
        }
        if (line.startsWith(" ") || trimmed.isEmpty()) {
            if (this.currentDocLines == null) {
                throw new IllegalStateException("unexpected parameter description found: define parameter first");
            }
            this.currentDocLines.add(line);
            return LineHandleResult.CONTINUE;
        }
        Matcher parameterNameTypeMatcher = this.PARAMETER_NAME_TYPE.matcher(trimmed);
        if (parameterNameTypeMatcher.find()) {
            this.startNewParam(parameterNameTypeMatcher.group(1), parameterNameTypeMatcher.group(2));
            return LineHandleResult.CONTINUE;
        }
        return LineHandleResult.BREAK;
    }

    private void startNewParam(String name, String type) {
        this.flushParamIfRequired();
        this.currentName = name;
        this.currentType = type;
        this.currentDocLines = new ArrayList<String>();
    }

    private void flushParamIfRequired() {
        if (this.currentName.isEmpty()) {
            return;
        }
        this.params.add(new PythonDocParam(this.currentName.trim(), this.currentType.trim(), StringUtils.stripIndentation((String)String.join((CharSequence)"\n", this.currentDocLines))));
        this.currentName = "";
    }

    private static enum LineHandleResult {
        CONTINUE,
        BREAK;

    }
}

