/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.server;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.StaticHandler;
import io.vertx.ext.web.impl.RoutingContextDecorator;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.testingisdocumenting.znai.html.HtmlPage;
import org.testingisdocumenting.znai.html.reactjs.HtmlReactJsPage;
import org.testingisdocumenting.znai.html.reactjs.ReactJsBundle;
import org.testingisdocumenting.znai.server.AuthenticationHandler;
import org.testingisdocumenting.znai.server.RoutesProviders;
import org.testingisdocumenting.znai.server.ServerLifecycleListeners;
import org.testingisdocumenting.znai.server.UrlContentHandlers;
import org.testingisdocumenting.znai.server.ZnaiServerConfig;
import org.testingisdocumenting.znai.server.auth.AuthorizationHandlers;
import org.testingisdocumenting.znai.server.auth.AuthorizationRequestLink;
import org.testingisdocumenting.znai.server.docpreparation.DocumentationPreparationHandlers;
import org.testingisdocumenting.znai.server.docpreparation.NoOpDocumentationPreparationProgress;
import org.testingisdocumenting.znai.server.sockets.WebSocketHandlers;
import org.testingisdocumenting.znai.utils.FileUtils;

public class ZnaiServer {
    private final Vertx vertx;
    private final ReactJsBundle reactJsBundle;
    private final ZnaiServerConfig serverConfig;
    private final AuthenticationHandler authenticationHandler;

    public ZnaiServer(ReactJsBundle reactJsBundle, Path deployRoot, AuthenticationHandler authenticationHandler) {
        this.reactJsBundle = reactJsBundle;
        this.serverConfig = new ZnaiServerConfig(deployRoot);
        this.authenticationHandler = authenticationHandler;
        System.setProperty("vertx.cwd", deployRoot.toString());
        System.setProperty("file.encoding", "UTF-8");
        ServerLifecycleListeners.beforeStart(this.serverConfig);
        FileUtils.symlinkAwareCreateDirs((Path)deployRoot);
        this.vertx = Vertx.vertx();
    }

    public HttpServer create() {
        HttpServer server = this.vertx.createHttpServer(new HttpServerOptions().setCompressionSupported(true));
        Router router = Router.router((Vertx)this.vertx);
        StaticHandler pagesStaticHandler = StaticHandler.create((String)".").setFilesReadOnly(false).setCachingEnabled(false);
        StaticHandler staticCommonResources = StaticHandler.create((String)"static").setMaxAgeSeconds(600L);
        router.get("/:docId/static/*").handler(ctx -> {
            MultiMap params = ctx.request().params();
            staticCommonResources.handle((Object)new RoutingContextDecorator(router.route("/" + params.get("docId") + "/static"), ctx));
        });
        router.get("/static/*").handler((Handler)staticCommonResources);
        this.registerCustomHandlersAndRoutes(router);
        this.registerPagesHandler(router, pagesStaticHandler);
        WebSocketHandlers.init(this.vertx);
        server.websocketHandler(WebSocketHandlers.handler);
        server.requestHandler(arg_0 -> ((Router)router).accept(arg_0));
        return server;
    }

    private void registerCustomHandlersAndRoutes(Router router) {
        UrlContentHandlers.urlContentHandlers().forEach(urlContentHandler -> router.get(urlContentHandler.url()).handler(ctx -> ctx.response().end(urlContentHandler.buildContent(this.serverConfig, (RoutingContext)ctx, this.reactJsBundle))));
        RoutesProviders.register(this.vertx, this.serverConfig, router);
    }

    private void registerPagesHandler(Router router, StaticHandler pagesStaticHandler) {
        router.get("/*").handler(ctx -> {
            if (ZnaiServer.needToEndWithTrailingSlash(ctx)) {
                this.redirectToTrailingSlash((RoutingContext)ctx);
                return;
            }
            String docId = ZnaiServer.extractDocId(ctx);
            if (!this.isAuthorized((RoutingContext)ctx, docId)) {
                if (ZnaiServer.isNotDocPageRequest(ctx)) {
                    ctx.fail(403);
                }
                this.serverNotAuthorizedPage((RoutingContext)ctx, docId);
                return;
            }
            if (DocumentationPreparationHandlers.isReady(docId)) {
                pagesStaticHandler.handle(ctx);
            } else if (ZnaiServer.isNotDocPageRequest(ctx)) {
                this.vertx.executeBlocking(future -> {
                    DocumentationPreparationHandlers.prepare(docId, NoOpDocumentationPreparationProgress.INSTANCE);
                    future.complete();
                }, false, res -> pagesStaticHandler.handle(ctx));
            } else {
                this.serveDocumentationPreparationPage((RoutingContext)ctx, docId);
            }
        });
    }

    private boolean isAuthorized(RoutingContext ctx, String docId) {
        String userId = this.authenticationHandler.authenticate(ctx, docId);
        if (userId.isEmpty()) {
            return true;
        }
        return AuthorizationHandlers.isAuthorized(userId, docId);
    }

    private void redirectToTrailingSlash(RoutingContext ctx) {
        ctx.response().putHeader("location", ctx.request().uri() + "/").setStatusCode(301).end();
    }

    private void serverNotAuthorizedPage(RoutingContext ctx, String docId) {
        HtmlReactJsPage htmlReactJsPage = new HtmlReactJsPage(this.reactJsBundle);
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("docId", docId);
        props.put("allowedGroups", AuthorizationHandlers.allowedGroups(docId));
        AuthorizationRequestLink authorizationRequestLink = AuthorizationHandlers.authorizationRequestLink();
        props.put("authorizationRequestLink", authorizationRequestLink.getLink());
        props.put("authorizationRequestMessage", authorizationRequestLink.getMessage());
        HtmlPage htmlPage = htmlReactJsPage.create(docId + ": Not Authorized", "NotAuthorizedScreen", props, () -> "", "/static/favicon/default.png");
        ctx.response().end(htmlPage.render(docId));
    }

    private void serveDocumentationPreparationPage(RoutingContext ctx, String docId) {
        HtmlReactJsPage htmlReactJsPage = new HtmlReactJsPage(this.reactJsBundle);
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("docId", docId);
        props.put("statusMessage", "checking documentation cache");
        props.put("progressPercent", 0);
        props.put("keyValues", Collections.emptyList());
        HtmlPage htmlPage = htmlReactJsPage.create("Preparing " + docId, "DocumentationPreparationScreen", props, () -> "", "/static/favicon/default.png");
        ctx.response().end(htmlPage.render(docId));
    }

    private static boolean needToEndWithTrailingSlash(RoutingContext ctx) {
        if (ZnaiServer.isNotDocPageRequest(ctx)) {
            return false;
        }
        return !ctx.request().uri().endsWith("/");
    }

    private static String extractDocId(RoutingContext ctx) {
        String uri = ctx.request().uri();
        String[] parts = uri.split("/");
        return parts.length < 2 ? "" : parts[1];
    }

    private static boolean isNotDocPageRequest(RoutingContext ctx) {
        String uri = ctx.request().uri();
        int dotIdx = uri.lastIndexOf(46);
        if (dotIdx == -1) {
            return false;
        }
        int slashIdx = uri.lastIndexOf(47);
        if (slashIdx > dotIdx) {
            return false;
        }
        String extension = uri.substring(dotIdx);
        return !extension.equals("html");
    }
}

