/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.server.docpreparation;

import java.util.Set;
import org.testingisdocumenting.znai.server.docpreparation.DocumentationPreparationHandler;
import org.testingisdocumenting.znai.server.docpreparation.DocumentationPreparationProgress;
import org.testingisdocumenting.znai.server.docpreparation.LocalDiskOnlyPreparationHandler;
import org.testingisdocumenting.znai.utils.ServiceLoaderUtils;

public class DocumentationPreparationHandlers {
    private static final DocumentationPreparationHandler localDiskHandler = new LocalDiskOnlyPreparationHandler();
    private static final Set<DocumentationPreparationHandler> handlers = ServiceLoaderUtils.load(DocumentationPreparationHandler.class);

    public static void prepare(String docId, DocumentationPreparationProgress preparationProgress) {
        DocumentationPreparationHandler handler = DocumentationPreparationHandlers.findHandler(docId);
        handler.prepare(docId, preparationProgress);
    }

    public static boolean isReady(String docId) {
        return DocumentationPreparationHandlers.findHandler(docId).isReady(docId);
    }

    public static void add(DocumentationPreparationHandler handler) {
        handlers.add(handler);
    }

    private static DocumentationPreparationHandler findHandler(String docId) {
        return handlers.stream().filter(h -> h.handles(docId)).findFirst().orElse(localDiskHandler);
    }
}

