/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.server.auth;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.server.auth.AuthorizationHandler;
import org.testingisdocumenting.znai.server.auth.AuthorizationRequestLink;
import org.testingisdocumenting.znai.utils.ServiceLoaderUtils;

public class AuthorizationHandlers {
    private static final Set<AuthorizationHandler> handlers = ServiceLoaderUtils.load(AuthorizationHandler.class);

    public static boolean isAuthorized(String userId, String docId) {
        if (handlers.isEmpty()) {
            return true;
        }
        return handlers.stream().anyMatch(h -> h.isAuthorized(userId, docId));
    }

    public static AuthorizationRequestLink authorizationRequestLink() {
        return handlers.stream().map(AuthorizationHandler::authorizationRequestLink).filter(link -> !link.isEmpty()).findFirst().orElse(new AuthorizationRequestLink("", ""));
    }

    public static List<String> allowedGroups(String docId) {
        return handlers.stream().flatMap(h -> h.allowedGroups(docId).stream()).collect(Collectors.toList());
    }

    public static void add(AuthorizationHandler handler) {
        handlers.add(handler);
    }

    public static void remove(AuthorizationHandler handler) {
        handlers.remove(handler);
    }
}

