/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.server.preview;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.core.DocMeta;
import org.testingisdocumenting.znai.html.DocPageReactProps;
import org.testingisdocumenting.znai.html.HtmlPageAndPageProps;
import org.testingisdocumenting.znai.reference.DocReferences;
import org.testingisdocumenting.znai.server.preview.FileChangeHandler;
import org.testingisdocumenting.znai.server.preview.PreviewWebSocketHandler;
import org.testingisdocumenting.znai.structure.Footer;
import org.testingisdocumenting.znai.structure.TocItem;
import org.testingisdocumenting.znai.utils.FileUtils;
import org.testingisdocumenting.znai.website.TocAddedAndRemovedPages;
import org.testingisdocumenting.znai.website.WebSite;

public class PreviewPushFileChangeHandler
implements FileChangeHandler {
    private final PreviewWebSocketHandler previewSocket;
    private final WebSite previewWebSite;

    public PreviewPushFileChangeHandler(PreviewWebSocketHandler previewSocket, WebSite previewWebSite) {
        this.previewSocket = previewSocket;
        this.previewWebSite = previewWebSite;
    }

    @Override
    public void onTocChange(Path tocPath) {
        ConsoleOutputs.out((Object[])new Object[]{"toc changed: ", tocPath});
        this.execute(() -> {
            TocAddedAndRemovedPages tocAddedAndRemovedPages = this.previewWebSite.updateToc();
            this.previewSocket.sendToc(tocAddedAndRemovedPages.getTableOfContents());
            if (!tocAddedAndRemovedPages.getAddedPagesProps().isEmpty()) {
                this.previewSocket.sendPages(tocAddedAndRemovedPages.getAddedPagesProps().stream().map(HtmlPageAndPageProps::getProps));
            }
            if (!tocAddedAndRemovedPages.getRemovedTocItems().isEmpty()) {
                this.previewSocket.sendPagesRemove(tocAddedAndRemovedPages.getRemovedTocItems().stream());
            }
        });
    }

    @Override
    public void onFooterChange(Path tocPath) {
        ConsoleOutputs.out((Object[])new Object[]{"footer changed: ", tocPath});
        this.execute(() -> {
            Footer footer = this.previewWebSite.parseFooter();
            this.previewSocket.sendFooter(footer);
        });
    }

    @Override
    public void onGlobalDocReferencesChange(Path docReferencePath) {
        ConsoleOutputs.out((Object[])new Object[]{"global doc references changed: ", docReferencePath});
        this.execute(() -> {
            DocReferences docReferences = this.previewWebSite.updateDocReferences();
            this.previewSocket.sendDocReferences(docReferences);
        });
    }

    @Override
    public void onDocMetaChange(Path metaPath) {
        ConsoleOutputs.out((Object[])new Object[]{"meta changed: ", metaPath});
        this.execute(() -> {
            String metaJson = FileUtils.fileTextContent((Path)metaPath);
            DocMeta newDocMeta = this.previewWebSite.getDocMeta().cloneWithNewJson(metaJson);
            this.previewSocket.sendMeta(newDocMeta);
        });
    }

    private HtmlPageAndPageProps regenerate(Path markupPath) {
        TocItem tocItem = this.previewWebSite.tocItemByPath(markupPath);
        if (tocItem == null) {
            return null;
        }
        return this.previewWebSite.regenerateAndValidatePageDeployTocAndAllPages(tocItem);
    }

    @Override
    public void onChange(Path path) {
        ConsoleOutputs.out((Object[])new Object[]{"file changed: ", path});
        TocItem tocItem = this.previewWebSite.tocItemByPath(path);
        if (tocItem == null) {
            ConsoleOutputs.out((Object[])new Object[]{path + " is not part of table of contents, checking dependent files"});
            this.onDependentChange(path);
        } else {
            this.onMarkupChange(path);
        }
    }

    private void onMarkupChange(Path path) {
        this.execute(() -> {
            HtmlPageAndPageProps htmlPageAndPageProps = this.regenerate(path);
            if (htmlPageAndPageProps == null) {
                return;
            }
            this.previewSocket.sendPage(htmlPageAndPageProps.getProps());
            this.previewSocket.sendToc(this.previewWebSite.getToc());
        });
    }

    private void onDependentChange(Path path) {
        this.execute(() -> {
            Set dependentTocItems = this.previewWebSite.dependentTocItems(path);
            if (dependentTocItems.isEmpty()) {
                ConsoleOutputs.out((Object[])new Object[]{"no markup files depends on ", Color.BLUE, path});
                return;
            }
            this.previewWebSite.redeployAuxiliaryFileIfRequired(path);
            dependentTocItems.forEach(System.out::println);
            Stream<DocPageReactProps> generatedPages = dependentTocItems.stream().map(tocItem -> this.previewWebSite.regenerateAndValidatePageDeployTocAndAllPages(tocItem).getProps());
            this.previewSocket.sendPages(generatedPages);
            this.previewSocket.sendToc(this.previewWebSite.getToc());
        });
    }

    private void execute(Runnable code) {
        try {
            code.run();
        }
        catch (Exception e) {
            ConsoleOutputs.err((Object[])new Object[]{e.getMessage()});
            this.previewSocket.sendError(e.getMessage(), PreviewPushFileChangeHandler.renderStackTrace(e));
        }
    }

    private static String renderStackTrace(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        return stringWriter.toString();
    }
}

