/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.parser.sphinx.python;

import java.util.stream.Collectors;
import org.testingisdocumenting.znai.parser.sphinx.python.PythonFunction;
import org.testingisdocumenting.znai.parser.sphinx.python.PythonFunctionParam;
import org.testingisdocumenting.znai.parser.sphinx.python.PythonFunctionParamSignature;
import org.testingisdocumenting.znai.utils.XmlUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PythonFunctionXmlParser {
    private static final String PARAM_TYPE_NODE_NAME = "literal_emphasis";
    private PythonFunction function;

    public PythonFunction parse(Node desc) {
        Node descSignature = XmlUtils.nodeByName((Node)desc, (String)"desc_signature");
        Node descName = XmlUtils.nodeByName((Node)descSignature, (String)"desc_name");
        Node descContent = XmlUtils.nodeByName((Node)desc, (String)"desc_content");
        Node paragraph = XmlUtils.nodeByName((Node)descContent, (String)"paragraph");
        this.function = new PythonFunction(XmlUtils.getAttributeText((Node)descSignature, (String)"ids"), descName.getTextContent(), paragraph.getTextContent());
        this.parseSignature(descSignature);
        XmlUtils.nodesStreamByName((Node)descContent, (String)"field").forEach(this::parseFields);
        return this.function;
    }

    private void parseFields(Node node) {
        Node fieldName = XmlUtils.nodeByName((Node)node, (String)"field_name");
        if (fieldName.getTextContent().equals("Parameters")) {
            XmlUtils.nodesStreamByName((Node)node, (String)"list_item").forEach(this::parseParam);
        }
    }

    private void parseSignature(Node descSignature) {
        Node paramsList = XmlUtils.nodeByName((Node)descSignature, (String)"desc_parameterlist");
        NodeList childNodes = paramsList.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            boolean isOptional = node.getNodeName().equals("desc_optional");
            this.function.addParamSignature(new PythonFunctionParamSignature(node.getTextContent(), isOptional));
        }
    }

    private void parseParam(Node listItem) {
        String paramName = XmlUtils.nodeByName((Node)listItem, (String)"literal_strong").getTextContent();
        String paramType = PythonFunctionXmlParser.parseParamType(listItem);
        Node paragraph = XmlUtils.nodeByName((Node)listItem, (String)"paragraph");
        String description = PythonFunctionXmlParser.extractParamDesc(paragraph);
        this.function.addParam(new PythonFunctionParam(paramName, paramType, description));
    }

    private static String parseParamType(Node listItem) {
        return XmlUtils.nodesStreamByName((Node)listItem, (String)PARAM_TYPE_NODE_NAME).map(Node::getTextContent).collect(Collectors.joining(" "));
    }

    private static String extractParamDesc(Node paragraph) {
        String remainingText = paragraph.getLastChild().getTextContent().trim();
        if (remainingText.startsWith(")")) {
            return remainingText.replaceAll("^\\) \u2013 ", "");
        }
        return remainingText.replaceAll("^\u2013 ", "");
    }
}

