/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.testingisdocumenting.znai.utils.JsonParseException;

public class JsonUtils {
    private static final ObjectMapper serializeMapper = JsonUtils.createDeserializeMapper();
    private static final ObjectMapper serializePrettyPrintMapper = JsonUtils.createSerializePrettyPrintMapper();
    private static final ObjectMapper deserializeMapper = JsonUtils.createDeserializeMapper();

    private JsonUtils() {
    }

    public static String serialize(Object json) {
        if (json == null) {
            return null;
        }
        try {
            return serializeMapper.writeValueAsString(json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException();
        }
    }

    public static String serializePrettyPrint(Object json) {
        if (json == null) {
            return null;
        }
        try {
            return serializePrettyPrintMapper.writeValueAsString(json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, ?> deserializeAsMap(String json) {
        if (json == null) {
            return null;
        }
        try {
            return (Map)deserializeMapper.readValue(json, Map.class);
        }
        catch (IOException e) {
            throw new JsonParseException(e.getMessage());
        }
    }

    public static List<?> deserializeAsList(String json) {
        if (json == null) {
            return null;
        }
        try {
            return (List)deserializeMapper.readValue(json, List.class);
        }
        catch (IOException e) {
            throw new JsonParseException(e.getMessage());
        }
    }

    public static Object deserialize(String json) {
        if (json == null) {
            return null;
        }
        try {
            return deserializeMapper.readValue(json, Object.class);
        }
        catch (IOException e) {
            throw new JsonParseException(e.getMessage());
        }
    }

    public static boolean isObjectScopeClosed(String json) {
        int previousChar = 32;
        int scopeBalance = 0;
        boolean insideSingleQuote = false;
        boolean insideDoubleQuote = false;
        boolean metScope = false;
        for (int idx = 0; idx < json.length(); ++idx) {
            boolean isPreviousCharEscape;
            char c = json.charAt(idx);
            boolean bl = isPreviousCharEscape = previousChar == 92;
            if (!isPreviousCharEscape) {
                if (c == '\'') {
                    boolean bl2 = insideSingleQuote = !insideSingleQuote;
                }
                if (c == '\"') {
                    boolean bl3 = insideDoubleQuote = !insideDoubleQuote;
                }
            }
            if (!insideDoubleQuote && !insideSingleQuote) {
                if (c == '{') {
                    metScope = true;
                    ++scopeBalance;
                } else if (c == '}') {
                    --scopeBalance;
                }
            }
            previousChar = c;
        }
        return metScope && scopeBalance == 0;
    }

    private static ObjectMapper createDeserializeMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonReadFeature.ALLOW_JAVA_COMMENTS.mappedFeature(), true);
        mapper.configure(JsonReadFeature.ALLOW_YAML_COMMENTS.mappedFeature(), true);
        mapper.configure(JsonReadFeature.ALLOW_TRAILING_COMMA.mappedFeature(), true);
        mapper.configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature(), true);
        mapper.configure(JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES.mappedFeature(), true);
        mapper.configure(JsonReadFeature.ALLOW_SINGLE_QUOTES.mappedFeature(), true);
        mapper.configure(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER.mappedFeature(), true);
        mapper.configure(JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS.mappedFeature(), true);
        mapper.configure(StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION.mappedFeature(), true);
        return mapper;
    }

    private static ObjectMapper createSerializeMapper() {
        return new ObjectMapper();
    }

    private static ObjectMapper createSerializePrettyPrintMapper() {
        ObjectMapper mapper = JsonUtils.createSerializeMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        return mapper;
    }
}

