/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.cli;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.features.PluginFeature;
import org.testingisdocumenting.znai.extensions.features.PluginFeatureList;
import org.testingisdocumenting.znai.extensions.file.SnippetContentProvider;
import org.testingisdocumenting.znai.extensions.file.SnippetHighlightFeature;
import org.testingisdocumenting.znai.extensions.file.SnippetRevealLineStopFeature;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class CliOutputIncludePlugin
implements IncludePlugin,
SnippetContentProvider {
    private String fileName;
    private Path filePath;
    private List<String> lines;
    private PluginFeatureList features;

    public String id() {
        return "cli-output";
    }

    public IncludePlugin create() {
        return new CliOutputIncludePlugin();
    }

    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        ResourcesResolver resourcesResolver = componentsRegistry.resourceResolver();
        this.fileName = pluginParams.getFreeParam();
        this.filePath = resourcesResolver.fullPath(this.fileName);
        this.features = new PluginFeatureList(new PluginFeature[]{new SnippetRevealLineStopFeature(pluginParams, (SnippetContentProvider)this), new SnippetHighlightFeature(componentsRegistry, pluginParams, (SnippetContentProvider)this)});
        LinkedHashMap<String, List<String>> props = new LinkedHashMap<String, List<String>>(pluginParams.getOpts().toMap());
        this.lines = CliOutputIncludePlugin.readLines(componentsRegistry, this.filePath);
        props.put("lines", this.lines);
        props.putAll(pluginParams.getOpts().toMap());
        this.features.updateProps(props);
        return PluginResult.docElement((String)"CliOutput", props);
    }

    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.concat(Stream.of(AuxiliaryFile.builtTime((Path)this.filePath)), this.features.auxiliaryFiles());
    }

    private static List<String> readLines(ComponentsRegistry componentsRegistry, Path filePath) {
        return Arrays.asList(componentsRegistry.resourceResolver().textContent(filePath).split("\n"));
    }

    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(String.join((CharSequence)" ", this.lines));
    }

    public String snippetContent() {
        return String.join((CharSequence)"\n", this.lines);
    }

    public String snippetId() {
        return this.fileName;
    }
}

