/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.json;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.utils.JsonUtils;

public class JsonIncludePlugin
implements IncludePlugin {
    private String fileName;
    private ResourcesResolver resourcesResolver;
    private Path pathsFilePath;

    public String id() {
        return "json";
    }

    public IncludePlugin create() {
        return new JsonIncludePlugin();
    }

    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.resourcesResolver = componentsRegistry.resourceResolver();
        this.fileName = pluginParams.getFreeParam();
        String json = this.resourcesResolver.textContent(this.fileName);
        String jsonPath = (String)pluginParams.getOpts().get("include", (Object)"$");
        Object content = JsonPath.read((String)json, (String)jsonPath, (Predicate[])new Predicate[0]);
        Map props = pluginParams.getOpts().toMap();
        props.put("data", content);
        props.put("paths", this.extractPaths(pluginParams.getOpts()));
        return PluginResult.docElement((String)"Json", (Map)props);
    }

    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        Stream pathsFile = this.pathsFilePath == null ? Stream.empty() : Stream.of(AuxiliaryFile.builtTime((Path)this.pathsFilePath));
        return Stream.concat(pathsFile, Stream.of(AuxiliaryFile.builtTime((Path)componentsRegistry.resourceResolver().fullPath(this.fileName))));
    }

    private List<String> extractPaths(PluginParamsOpts opts) {
        if (opts.has("pathsFile")) {
            String filePath = (String)opts.get("pathsFile");
            this.pathsFilePath = this.resourcesResolver.fullPath(filePath);
            return JsonUtils.deserializeAsList((String)this.resourcesResolver.textContent(filePath));
        }
        return opts.getList("paths");
    }
}

