/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.html;

import org.testingisdocumenting.znai.html.DocPageReactProps;
import org.testingisdocumenting.znai.html.DocumentationReactProps;
import org.testingisdocumenting.znai.html.FooterProps;
import org.testingisdocumenting.znai.html.HtmlPage;
import org.testingisdocumenting.znai.html.HtmlPageAndPageProps;
import org.testingisdocumenting.znai.html.RenderSupplier;
import org.testingisdocumenting.znai.html.reactjs.HtmlReactJsPage;
import org.testingisdocumenting.znai.html.reactjs.ReactJsBundle;
import org.testingisdocumenting.znai.structure.DocMeta;
import org.testingisdocumenting.znai.structure.Footer;
import org.testingisdocumenting.znai.structure.Page;
import org.testingisdocumenting.znai.structure.TocItem;

public class PageToHtmlPageConverter {
    private final DocMeta docMeta;
    private final ReactJsBundle reactJsBundle;

    public PageToHtmlPageConverter(DocMeta docMeta, ReactJsBundle reactJsBundle) {
        this.docMeta = docMeta;
        this.reactJsBundle = reactJsBundle;
    }

    public HtmlPageAndPageProps convert(TocItem tocItem, Page page, RenderSupplier mainBodySupplier, Footer footer) {
        String title = tocItem.isIndex() ? this.docMeta.getTitle() : this.docMeta.getTitle() + ": " + tocItem.getPageTitle();
        DocPageReactProps pageProps = new DocPageReactProps(tocItem, page);
        FooterProps footerProps = new FooterProps(footer);
        DocumentationReactProps docProps = new DocumentationReactProps(this.docMeta, pageProps, footerProps);
        HtmlReactJsPage reactJsPage = new HtmlReactJsPage(this.reactJsBundle);
        HtmlPage htmlPage = reactJsPage.create(title, "Documentation", docProps.toMap(), mainBodySupplier, "");
        return new HtmlPageAndPageProps(htmlPage, pageProps);
    }
}

