/*
 * Copyright 2019 TWO SIGMA OPEN SOURCE, LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.testingisdocumenting.znai.extensions.markup;

import org.testingisdocumenting.znai.codesnippets.CodeSnippetsProps;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.parser.docelement.DocElementType;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;

public class MarkdownAndResultFencePlugin implements FencePlugin {
    @Override
    public String id() {
        return "markdown-and-result";
    }

    @Override
    public FencePlugin create() {
        return new MarkdownAndResultFencePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams, String content) {
        MarkupParser parser = componentsRegistry.defaultParser();
        MarkupParserResult parserResult = parser.parse(markupPath, content);

        Map<String, Object> markdown = CodeSnippetsProps.create("markdown", content);
        markdown.put("type", DocElementType.SNIPPET);

        Map<String, Object> props = new LinkedHashMap<>();
        props.put("markdown", markdown);
        props.put("result", parserResult.contentToListOfMaps());

        return PluginResult.docElement("MarkdownAndResult", props);
    }
}
