/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.cli;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;

class CliCommandPropsAndValidation {
    static final String CliDocElementName = "CliCommand";

    CliCommandPropsAndValidation() {
    }

    static Map<String, Object> createProps(String commandToRender, String commandToValidateProps, PluginParamsOpts opts) {
        LinkedHashSet<String> combinedParams = new LinkedHashSet<String>(opts.getList("paramToHighlight"));
        combinedParams.addAll(opts.getList("paramsToHighlight"));
        combinedParams.addAll(opts.getList("highlight"));
        if (opts.has("paramToHighlight") || opts.has("paramsToHighlight")) {
            ConsoleOutputs.out((Object[])new Object[]{Color.RED, "cli param(s)ToHighlight will be deprecated, use <highlight> instead"});
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("command", commandToRender);
        props.put("paramsToHighlight", combinedParams);
        CliCommandPropsAndValidation.validateParamsToHighlight(commandToValidateProps, combinedParams);
        opts.assignToProps(props, "meta");
        opts.assignToProps(props, "threshold");
        opts.assignToProps(props, "presentationThreshold");
        Set splitAfter = opts.getSet("splitAfter");
        if (!splitAfter.isEmpty()) {
            props.put("splitAfter", splitAfter);
            CliCommandPropsAndValidation.validateSplitAfter(commandToValidateProps, splitAfter);
        }
        return props;
    }

    private static void validateSplitAfter(String command, Set<String> splitAfter) {
        HashSet<String> commandParts = new HashSet<String>(Arrays.asList(command.split(" ")));
        for (String token : splitAfter) {
            if (commandParts.contains(token)) continue;
            throw new RuntimeException("split part \"" + token + "\" is not present in command: " + command);
        }
    }

    private static void validateParamsToHighlight(String command, Set<String> paramsToHighlight) {
        for (String paramToHighlight : paramsToHighlight) {
            if (command.contains(paramToHighlight)) continue;
            throw new RuntimeException("param to highlight \"" + paramToHighlight + "\" is not present in command: " + command);
        }
    }
}

