/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.image;

import java.awt.image.BufferedImage;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.image.CsvAnnotations;
import org.testingisdocumenting.znai.extensions.image.ImagePluginBase;
import org.testingisdocumenting.znai.extensions.image.RectCoord;
import org.testingisdocumenting.znai.extensions.image.ShapeColorAnalyzer;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.utils.FilePathUtils;
import org.testingisdocumenting.znai.utils.FileUtils;
import org.testingisdocumenting.znai.utils.JsonUtils;

public class ImageIncludePlugin
extends ImagePluginBase
implements IncludePlugin {
    private static final String ANNOTATIONS_PATH_KEY = "annotationsPath";
    private static final String ANNOTATE_KEY = "annotate";
    private Map<String, ?> parsedJson;
    private ResourcesResolver resourceResolver;
    private ComponentsRegistry componentsRegistry;
    private Path markupPath;
    protected Path annotationsPath;
    private boolean isJsonFile;
    private String annotationsFileContent;

    public IncludePlugin create() {
        return new ImageIncludePlugin();
    }

    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.resourceResolver = componentsRegistry.resourceResolver();
        this.componentsRegistry = componentsRegistry;
        this.markupPath = markupPath;
        String imagePath = pluginParams.getFreeParam();
        this.annotationsPath = this.determineAnnotationsPath(imagePath, pluginParams);
        this.preparseJsonFileIfJson();
        return this.process(componentsRegistry, markupPath, pluginParams);
    }

    private void preparseJsonFileIfJson() {
        if (this.annotationsPath == null) {
            return;
        }
        this.annotationsFileContent = FileUtils.fileTextContent((Path)this.annotationsPath);
        this.isJsonFile = this.annotationsFileContent.trim().startsWith("{");
        if (this.isJsonFile) {
            this.parsedJson = JsonUtils.deserializeAsMap((String)this.annotationsFileContent);
        }
    }

    @Override
    protected List<Map<String, Object>> annotationShapes(BufferedImage image) {
        if (this.annotationsPath == null) {
            return Collections.emptyList();
        }
        Double pixelRatio = this.pixelRatio();
        if (this.isJsonFile) {
            List shapes = (List)this.parsedJson.get("shapes");
            this.updateShapesWithAutoColorAndTooltips(image, pixelRatio, shapes);
            return shapes;
        }
        return new CsvAnnotations(this.componentsRegistry.markdownParser(), this.markupPath, image, pixelRatio).annotationsShapesFromCsv(this.annotationsFileContent);
    }

    @Override
    protected Double pixelRatio() {
        if (this.pixelRatioFromOpts != null) {
            return this.pixelRatioFromOpts;
        }
        return this.parsedJson == null || !this.parsedJson.containsKey("pixelRatio") ? 1.0 : ((Number)this.parsedJson.get("pixelRatio")).doubleValue();
    }

    @Override
    protected PluginParamsDefinition additionalParameters() {
        return new PluginParamsDefinition().add(ANNOTATIONS_PATH_KEY, PluginParamType.STRING, "path to a JSON file with annotations information", "annotations.json").add(ANNOTATE_KEY, PluginParamType.BOOLEAN, "automatically use the annotations file matching image file but with json extension", "true");
    }

    @Override
    protected Stream<AuxiliaryFile> additionalAuxiliaryFiles() {
        return this.annotationsPath != null ? Stream.of(AuxiliaryFile.builtTime((Path)this.annotationsPath)) : Stream.empty();
    }

    private void updateShapesWithAutoColorAndTooltips(BufferedImage image, Double pixelRatio, List<Map<String, Object>> shapes) {
        ShapeColorAnalyzer colorAnalyzer = new ShapeColorAnalyzer(image, pixelRatio);
        shapes.forEach(shape -> {
            String type = shape.get("type").toString();
            Boolean isInvertedColor = this.isInvertedColor(colorAnalyzer, type, (Map<String, ?>)shape);
            shape.put("invertedColors", isInvertedColor);
            Object text = shape.get("text");
            if (text != null && !text.toString().isEmpty() && !type.equals("badge")) {
                String markdown = text.toString();
                MarkupParserResult parserResult = this.componentsRegistry.markdownParser().parse(this.markupPath, markdown);
                shape.put("tooltip", parserResult.getDocElement().contentToListOfMaps());
            }
        });
    }

    private Boolean isInvertedColor(ShapeColorAnalyzer colorAnalyzer, String type, Map<String, ?> shape) {
        switch (type) {
            case "badge": {
                return colorAnalyzer.isDarkCoordinate((Number)shape.get("x"), (Number)shape.get("y"));
            }
            case "arrow": {
                return colorAnalyzer.isDarkBasedOnOppositeCorners(new RectCoord(shape));
            }
            case "rect": {
                return colorAnalyzer.isDarkBasedOnAllCorners(new RectCoord(shape));
            }
        }
        return false;
    }

    private Path determineAnnotationsPath(String imagePath, PluginParams pluginParams) {
        String annotationsPathValue = (String)pluginParams.getOpts().get(ANNOTATIONS_PATH_KEY);
        if (annotationsPathValue != null) {
            return this.resourceResolver.fullPath(annotationsPathValue);
        }
        if (!((Boolean)pluginParams.getOpts().get(ANNOTATE_KEY, (Object)false)).booleanValue()) {
            return null;
        }
        if (this.isExternal) {
            return null;
        }
        String jsonAnnotationsPath = FilePathUtils.replaceExtension((String)imagePath, (String)"json");
        if (this.resourceResolver.canResolve(jsonAnnotationsPath)) {
            return this.resourceResolver.fullPath(jsonAnnotationsPath);
        }
        String csvAnnotationsPath = FilePathUtils.replaceExtension((String)imagePath, (String)"csv");
        if (this.resourceResolver.canResolve(csvAnnotationsPath)) {
            return this.resourceResolver.fullPath(csvAnnotationsPath);
        }
        throw new RuntimeException("can't find any of the files: " + jsonAnnotationsPath + "; " + csvAnnotationsPath);
    }
}

