/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.image;

import java.awt.image.BufferedImage;
import org.testingisdocumenting.znai.extensions.image.ImageUtils;
import org.testingisdocumenting.znai.extensions.image.RectCoord;

class ShapeColorAnalyzer {
    private final BufferedImage image;
    private final Double pixelRatio;

    ShapeColorAnalyzer(BufferedImage image, Double pixelRatio) {
        this.image = image;
        this.pixelRatio = pixelRatio;
    }

    boolean isDarkCoordinate(Number x, Number y) {
        int xAsInt = (int)(x.doubleValue() * this.pixelRatio);
        int yAsInt = (int)(y.doubleValue() * this.pixelRatio);
        if (xAsInt < 0 || yAsInt < 0 || xAsInt >= this.image.getWidth() || yAsInt >= this.image.getHeight()) {
            throw new IllegalArgumentException("x: " + xAsInt + "; y: " + yAsInt + "; pixelRatio: " + this.pixelRatio + " is outside the image (width: " + this.image.getWidth() + "; height: " + this.image.getHeight() + ")");
        }
        return ImageUtils.colorDarknessRatio(this.image, xAsInt, yAsInt, (int)(10.0 * this.pixelRatio)) > 0.5;
    }

    boolean isDarkBasedOnOppositeCorners(RectCoord rectCoord) {
        return this.isDarkCoordinate(rectCoord.getBeginX(), rectCoord.getBeginY()) || this.isDarkCoordinate(rectCoord.getEndX(), rectCoord.getEndY());
    }

    boolean isDarkBasedOnAllCorners(RectCoord rectCoord) {
        int numberOfDarkAreas = 0;
        if (this.isDarkCoordinate(rectCoord.getBeginX(), rectCoord.getBeginY())) {
            ++numberOfDarkAreas;
        }
        if (this.isDarkCoordinate(rectCoord.getBeginX(), rectCoord.getEndY())) {
            ++numberOfDarkAreas;
        }
        if (this.isDarkCoordinate(rectCoord.getEndX(), rectCoord.getBeginY())) {
            ++numberOfDarkAreas;
        }
        if (this.isDarkCoordinate(rectCoord.getEndX(), rectCoord.getEndY())) {
            ++numberOfDarkAreas;
        }
        return numberOfDarkAreas >= 2;
    }
}

