/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.markup;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import org.testingisdocumenting.znai.codesnippets.CodeSnippetsProps;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;

public class MarkdownAndResultFencePlugin
implements FencePlugin {
    public String id() {
        return "markdown-and-result";
    }

    public FencePlugin create() {
        return new MarkdownAndResultFencePlugin();
    }

    public PluginResult process(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams, String content) {
        MarkupParser parser = componentsRegistry.defaultParser();
        MarkupParserResult parserResult = parser.parse(markupPath, content);
        Map markdown = CodeSnippetsProps.create((String)"markdown", (String)content);
        markdown.put("type", "Snippet");
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("markdown", markdown);
        props.put("result", parserResult.contentToListOfMaps());
        return PluginResult.docElement((String)"MarkdownAndResult", props);
    }
}

