/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.markup;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;
import org.testingisdocumenting.znai.utils.FileUtils;

public class MarkdownsIncludePlugin
implements IncludePlugin {
    private static final String SORT_KEY = "sort";
    private static final String ASCENDING = "ascending";
    private static final String DESCENDING = "descending";
    private List<Path> markdowns;
    private List<MarkupParserResult> parserResults;
    private PluginParamsOpts opts;

    public String id() {
        return "markdowns";
    }

    public IncludePlugin create() {
        return new MarkdownsIncludePlugin();
    }

    public PluginParamsDefinition parameters() {
        return new PluginParamsDefinition().add(SORT_KEY, PluginParamType.STRING, "sort direction, ascending or descending (descending is default)", "\"ascending\"");
    }

    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.opts = pluginParams.getOpts();
        Path dir = componentsRegistry.resourceResolver().fullPath(pluginParams.getFreeParam());
        MarkupParser parser = componentsRegistry.defaultParser();
        this.markdowns = this.markdowns(dir).collect(Collectors.toList());
        this.parserResults = this.markdowns.stream().map(p -> parser.parse(markupPath, FileUtils.fileTextContent((Path)p))).collect(Collectors.toList());
        Stream elements = this.parserResults.stream().flatMap(r -> r.getDocElement().getContent().stream());
        return PluginResult.docElements(elements);
    }

    private Stream<Path> markdowns(Path dir) {
        try {
            return Files.list(dir).filter(f -> f.toString().endsWith(".md")).sorted(this.createComparator());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Comparator<Path> createComparator() {
        Comparator<Path> comparator = Comparator.comparing(Path::toString);
        String sortDirection = (String)this.opts.get(SORT_KEY, (Object)"");
        if (sortDirection.isEmpty() || sortDirection.equals(DESCENDING)) {
            return comparator.reversed();
        }
        if (!sortDirection.equals(ASCENDING)) {
            throw new IllegalArgumentException("sort only accepts <ascending>, or <descending>");
        }
        return comparator;
    }

    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return this.markdowns.stream().map(AuxiliaryFile::builtTime);
    }

    public SearchText textForSearch() {
        String textFromMarkupResults = this.parserResults.stream().map(MarkupParserResult::getAllText).collect(Collectors.joining(" "));
        return SearchScore.STANDARD.text(textFromMarkupResults);
    }
}

