/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.table;

import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.file.AnchorFeature;
import org.testingisdocumenting.znai.extensions.table.MarkupTableDataFromContentAndParams;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.parser.table.MarkupTableData;

class TableDocElementFromParams {
    private final PluginParams pluginParams;
    private final MarkupParser parser;
    private final Path fullPath;
    private final AnchorFeature anchorFeature;
    private final MarkupTableDataFromContentAndParams markupTableDataFromContentAndParams;
    private MarkupTableData modifiedTable;

    TableDocElementFromParams(ComponentsRegistry componentsRegistry, MarkupTableDataFromContentAndParams markupTableDataFromContentAndParams, Path markupParentPath, PluginParams pluginParams, MarkupParser parser, Path fullPath) {
        this.markupTableDataFromContentAndParams = markupTableDataFromContentAndParams;
        this.anchorFeature = new AnchorFeature(componentsRegistry.docStructure(), markupParentPath, pluginParams);
        this.pluginParams = pluginParams;
        this.parser = parser;
        this.fullPath = fullPath;
    }

    MarkupTableData getModifiedTable() {
        return this.modifiedTable;
    }

    PluginResult create() {
        PluginParamsOpts opts = this.pluginParams.getOpts();
        this.modifiedTable = this.createModifiedTable(opts);
        Map tableAsMap = this.modifiedTable.toMap();
        List columns = (List)tableAsMap.get("columns");
        opts.forEach((columnName, meta) -> {
            Optional<Map> column = columns.stream().filter(c -> {
                Object columnTitle = c.get("title");
                return columnName.equals(columnTitle) || columnName.equals("_" + columnTitle);
            }).findFirst();
            column.ifPresent(c -> c.putAll((Map)meta));
        });
        tableAsMap.put("data", this.parseMarkupInEachRow((List)tableAsMap.get("data")));
        opts.assignToProps(tableAsMap, "minColumnWidth");
        opts.assignToProps(tableAsMap, "wide");
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("table", tableAsMap);
        this.handleHighlight(props);
        opts.assignToProps(props, "title");
        opts.assignToProps(props, "anchorId");
        opts.assignToProps(props, "noGap");
        opts.assignToProps(props, "collapsed");
        this.anchorFeature.updateProps(props);
        return PluginResult.docElement((String)"Table", props);
    }

    private MarkupTableData createModifiedTable(PluginParamsOpts opts) {
        MarkupTableData result = this.markupTableDataFromContentAndParams.getMarkupTableData();
        if (opts.has("columns")) {
            result = result.withColumnsInOrder(opts.getList("columns"));
        }
        if (opts.has("includeRowsRegexp")) {
            result = result.withRowsMatchingRegexp(opts.getList("includeRowsRegexp"));
        }
        if (opts.has("excludeRowsRegexp")) {
            result = result.withoutRowsMatchingRegexp(opts.getList("excludeRowsRegexp"));
        }
        return result;
    }

    private void handleHighlight(Map<String, Object> props) {
        List rows = this.pluginParams.getOpts().getList("highlightRow");
        if (rows.isEmpty()) {
            return;
        }
        props.put("highlightRowIndexes", rows);
    }

    private List<Object> parseMarkupInEachRow(List<List<Object>> rows) {
        return rows.stream().map(this::parseMarkupInCell).collect(Collectors.toList());
    }

    private List<Object> parseMarkupInCell(List<Object> row) {
        return row.stream().map(this::parseMarkupInCell).collect(Collectors.toList());
    }

    private List<Object> parseMarkupInCell(Object cell) {
        if (cell == null) {
            return Collections.emptyList();
        }
        MarkupParserResult parserResult = this.parser.parse(this.fullPath, cell.toString());
        return (List)parserResult.getDocElement().toMap().get("content");
    }
}

