/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.table;

import java.nio.file.Path;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.extensions.table.MarkupTableDataFromContentAndParams;
import org.testingisdocumenting.znai.extensions.table.TableDocElementFromParams;
import org.testingisdocumenting.znai.extensions.table.TablePluginParams;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class TableFencePlugin
implements FencePlugin {
    private TableDocElementFromParams docElementFromParams;
    private MarkupTableDataFromContentAndParams tableDataFromContentAndParams;

    public String id() {
        return "table";
    }

    public FencePlugin create() {
        return new TableFencePlugin();
    }

    public void preprocess(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams, String content) {
        this.tableDataFromContentAndParams = new MarkupTableDataFromContentAndParams(componentsRegistry, pluginParams, content);
    }

    public PluginParamsDefinition parameters() {
        return TablePluginParams.paramsFromColumnNames(this.tableDataFromContentAndParams);
    }

    public PluginResult process(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams, String content) {
        ResourcesResolver resourcesResolver = componentsRegistry.resourceResolver();
        MarkupParser parser = componentsRegistry.defaultParser();
        String fileName = pluginParams.getFreeParam();
        this.docElementFromParams = new TableDocElementFromParams(componentsRegistry, this.tableDataFromContentAndParams, markupPath, pluginParams, parser, resourcesResolver.fullPath(fileName));
        return this.docElementFromParams.create();
    }

    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(this.docElementFromParams.getModifiedTable().allText());
    }
}

