/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.table;

import java.nio.file.Path;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.extensions.table.MarkupTableDataFromContentAndParams;
import org.testingisdocumenting.znai.extensions.table.TableDocElementFromParams;
import org.testingisdocumenting.znai.extensions.table.TablePluginParams;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class TableIncludePlugin
implements IncludePlugin {
    private Path fullPath;
    private TableDocElementFromParams docElementFromParams;
    private MarkupTableDataFromContentAndParams tableDataFromContentAndParams;

    public String id() {
        return "table";
    }

    public IncludePlugin create() {
        return new TableIncludePlugin();
    }

    public void preprocess(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams) {
        ResourcesResolver resourcesResolver = componentsRegistry.resourceResolver();
        String fileName = pluginParams.getFreeParam();
        String textContent = resourcesResolver.textContent(fileName);
        this.fullPath = resourcesResolver.fullPath(fileName);
        this.tableDataFromContentAndParams = new MarkupTableDataFromContentAndParams(componentsRegistry, pluginParams, textContent);
    }

    public PluginParamsDefinition parameters() {
        return TablePluginParams.paramsFromColumnNames(this.tableDataFromContentAndParams);
    }

    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.docElementFromParams = new TableDocElementFromParams(componentsRegistry, this.tableDataFromContentAndParams, markupPath, pluginParams, componentsRegistry.defaultParser(), this.fullPath);
        return this.docElementFromParams.create();
    }

    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.concat(Stream.of(AuxiliaryFile.builtTime((Path)this.fullPath)), this.tableDataFromContentAndParams.mappingAuxiliaryFile());
    }

    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(this.docElementFromParams.getModifiedTable().allText());
    }
}

