/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.table;

import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinitionCommon;
import org.testingisdocumenting.znai.extensions.table.MarkupTableDataFromContentAndParams;

class TablePluginParams {
    static final String INCLUDE_ROWS_REGEXP_KEY = "includeRowsRegexp";
    static final String EXCLUDE_ROWS_REGEXP_KEY = "excludeRowsRegexp";
    private static final PluginParamsDefinition commonParamsDefinition = new PluginParamsDefinition().add(PluginParamsDefinitionCommon.container).add("mappingPath", PluginParamType.STRING, "csv file path with values mapping", "\"mapping.csv\"").add("columns", PluginParamType.LIST_OR_SINGLE_STRING, "list of columns to include/re-arrange", "[\"colA\", \"colB\"]").add("highlightRow", PluginParamType.LIST_OR_SINGLE_NUMBER, "row indexes to highlight", "[2, 5]").add("minColumnWidth", PluginParamType.NUMBER, "minimum columns width", "300").add("wide", PluginParamType.BOOLEAN, "use wide mode for the table", "true").add("includeRowsRegexp", PluginParamType.LIST_OR_SINGLE_STRING, "include rows that match provided list or a single value of regular expressions", "[\"hello\", \"\\d+\"]").add("excludeRowsRegexp", PluginParamType.LIST_OR_SINGLE_STRING, "exclude rows that match provided list or a single value of regular expressions", "[\"hello\", \"\\d+\"]");

    TablePluginParams() {
    }

    static PluginParamsDefinition paramsFromColumnNames(MarkupTableDataFromContentAndParams tableData) {
        PluginParamsDefinition result = new PluginParamsDefinition();
        result.add(commonParamsDefinition);
        tableData.columnNamesStream().forEach(columnName -> {
            String description = "column <" + columnName + "> config";
            String example = "{width: \"50%\"}";
            if (result.has(columnName)) {
                result.add("_" + columnName, PluginParamType.OBJECT, description, example);
            } else {
                result.add(columnName, PluginParamType.OBJECT, description, example);
            }
        });
        return result;
    }
}

