/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.html;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.website.WebResource;

public class Deployer {
    private final Path root;
    private final Set<Path> deployed;

    public Deployer(Path root) {
        this.root = root.toAbsolutePath().normalize();
        this.deployed = new HashSet<Path>();
    }

    public Path getRoot() {
        return this.root;
    }

    public void deploy(String relativePath, byte[] content) {
        this.deploy(Paths.get(relativePath, new String[0]), content);
    }

    public void deploy(String relativePath, String content) {
        this.deploy(Paths.get(relativePath, new String[0]), content);
    }

    public void deploy(Path relativePath, String content) {
        this.deploy(relativePath.toString(), relativePath, content);
    }

    public void deploy(String originalPathForLogging, Path relativePath, String content) {
        this.deploy(originalPathForLogging, relativePath, content.getBytes(StandardCharsets.UTF_8));
    }

    public void deploy(Path srcPath) {
        this.printDeployMessage(srcPath, this.root);
        try {
            FileUtils.copyDirectory((File)srcPath.toFile(), (File)this.root.toFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deploy(WebResource webResource) {
        this.deploy(Paths.get(webResource.getPath(), new String[0]), webResource.getBinaryContent());
    }

    public void deploy(WebResource webResource, String content) {
        this.deploy(Paths.get(webResource.getPath(), new String[0]), content);
    }

    public void deploy(Path relativePath, byte[] content) {
        this.deploy(relativePath.toString(), relativePath, content);
    }

    public void deploy(String originalPathForLogging, Path relativePath, byte[] content) {
        Path fullPath = this.root.resolve(relativePath);
        if (this.deployed.contains(fullPath)) {
            return;
        }
        this.printDeployMessage(originalPathForLogging, fullPath);
        try {
            Files.createDirectories(fullPath.getParent(), new FileAttribute[0]);
            Files.write(fullPath, content, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void printDeployMessage(Object from, Object to) {
        ConsoleOutputs.out((Object[])new Object[]{"deploying ", Color.PURPLE, from, Color.BLACK, " to ", Color.PURPLE, to});
    }
}

