/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.website;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.utils.FileUtils;
import org.testingisdocumenting.znai.website.WebResource;
import org.testingisdocumenting.znai.website.WebSiteResourcesProvider;

public class WebSiteLogoExtension
implements WebSiteResourcesProvider {
    private WebResource cssLogoResource;

    WebSiteLogoExtension(Path docRootPath) {
        Path logoPath = docRootPath.resolve("logo.png");
        this.cssLogoResource = Files.exists(logoPath, new LinkOption[0]) ? WebResource.withTextContent("logo.css", this.createLogoCss(logoPath)) : null;
    }

    @Override
    public Stream<WebResource> cssResources() {
        return this.cssLogoResource != null ? Stream.of(this.cssLogoResource) : Stream.empty();
    }

    private String createLogoCss(Path logoPath) {
        return ".znai-documentation-logo {\n    display: block;\n    background-size: contain;\n    background-image: url(data:image/png;base64," + this.imageToBase64(logoPath) + ")\n}\n";
    }

    private String imageToBase64(Path logoPath) {
        byte[] content = FileUtils.fileBinaryContent((Path)logoPath);
        return Base64.getEncoder().encodeToString(content);
    }
}

