/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.mvel2.ScriptMemoryOverflowException;
import org.mvel2.ScriptRuntimeException;
import org.mvel2.execution.ExecutionObject;

public class ExecutionContext
implements Serializable {
    private final Map<Object, ValueReference> valueReferenceMap = new IdentityHashMap<Object, ValueReference>();
    private final Map<String, Object> variablesMap = new HashMap<String, Object>();
    private final long maxAllowedMemory;
    private long memorySize = 0L;
    private final AtomicInteger idSequence = new AtomicInteger(0);
    private volatile boolean stopped = false;

    public ExecutionContext() {
        this(-1L);
    }

    public ExecutionContext(long maxAllowedMemory) {
        this.maxAllowedMemory = maxAllowedMemory;
    }

    public int nextId() {
        return this.idSequence.incrementAndGet();
    }

    public void checkExecution() {
        if (this.stopped) {
            throw new ScriptRuntimeException("Script execution is stopped!");
        }
    }

    public void stop() {
        this.stopped = true;
    }

    public Object checkAssignVariable(String varName, Object value) {
        Object prevValue;
        ValueReference reference;
        if (this.variablesMap.containsKey(varName) && (reference = this.valueReferenceMap.get(prevValue = this.variablesMap.get(varName))) != null && reference.removeReference(varName)) {
            this.valueReferenceMap.remove(prevValue);
            this.memorySize -= reference.getSize();
        }
        if (value != null) {
            this.variablesMap.put(varName, value);
            ValueReference reference2 = this.valueReferenceMap.computeIfAbsent(value, o -> {
                ValueReference newReference = new ValueReference();
                newReference.setSize(this.getValueSize(value));
                this.memorySize += newReference.getSize();
                return newReference;
            });
            reference2.addReference(varName);
        } else {
            this.variablesMap.remove(varName);
        }
        this.checkMemoryLimit();
        return value;
    }

    public long onValRemove(ExecutionObject obj, Object key, Object val) {
        long valSize = this.getValueSize(key) + this.getValueSize(val);
        ValueReference reference = this.valueReferenceMap.get(obj);
        if (reference != null) {
            reference.setSize(reference.getSize() - valSize);
        }
        this.memorySize -= valSize;
        return valSize;
    }

    public long onValAdd(ExecutionObject obj, Object key, Object val) {
        long valSize = this.getValueSize(key) + this.getValueSize(val);
        ValueReference reference = this.valueReferenceMap.get(obj);
        if (reference != null) {
            reference.setSize(reference.getSize() + valSize);
        }
        this.memorySize += valSize;
        this.checkMemoryLimit();
        return valSize;
    }

    public void dumpVars() {
        System.out.println("VARS:");
        this.variablesMap.forEach((key, value) -> System.out.println(key + " = " + value));
    }

    public void dumpValueReferences() {
        System.out.println("VALUE REFERENCES:");
        this.valueReferenceMap.forEach((key, value) -> System.out.println(key + " = " + value));
    }

    public long getMemorySize() {
        return this.memorySize;
    }

    private void checkMemoryLimit() {
        if (this.maxAllowedMemory > 0L && this.memorySize > this.maxAllowedMemory) {
            throw new ScriptMemoryOverflowException("Script memory overflow (" + this.memorySize + " > " + this.maxAllowedMemory + ")!");
        }
    }

    private long getValueSize(Object value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof ExecutionObject) {
            if (this.valueReferenceMap.containsKey(value)) {
                return 4L;
            }
            return ((ExecutionObject)value).memorySize();
        }
        if (value instanceof String) {
            return ((String)value).getBytes().length;
        }
        if (value instanceof Integer) {
            return 4L;
        }
        if (value instanceof Long) {
            return 8L;
        }
        if (value instanceof Float) {
            return 4L;
        }
        if (value instanceof Double) {
            return 8L;
        }
        if (value instanceof Boolean) {
            return 1L;
        }
        if (value instanceof Byte) {
            return 1L;
        }
        if (value instanceof UUID) {
            return 16L;
        }
        throw new ScriptRuntimeException("Unsupported value type: " + value.getClass());
    }

    private static final class ValueReference {
        private final Set<String> references = new HashSet<String>();
        private long size = 0L;

        private ValueReference() {
        }

        void addReference(String varName) {
            this.references.add(varName);
        }

        boolean removeReference(String varName) {
            this.references.remove(varName);
            return this.references.isEmpty();
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public String toString() {
            return "ValueReference[size: " + this.size + "; references: " + this.references + "]";
        }
    }
}

